/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@StatelessCheck
public class ConstructorsDeclarationGroupingCheck
extends AbstractCheck {
    public static final String MSG_KEY = "constructors.declaration.grouping";

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{14, 154, 199};
    }

    @Override
    public void visitToken(DetailAST ast) {
        List<DetailAST> children = ConstructorsDeclarationGroupingCheck.getChildList(ast);
        DetailAST firstConstructor = children.stream().filter(ConstructorsDeclarationGroupingCheck::isConstructor).findFirst().orElse(null);
        if (firstConstructor != null) {
            List<DetailAST> childrenAfterFirstConstructor = children.subList(children.indexOf(firstConstructor), children.size());
            Optional<Integer> indexOfFirstNonConstructor = childrenAfterFirstConstructor.stream().filter(currAst -> !ConstructorsDeclarationGroupingCheck.isConstructor(currAst)).findFirst().map(children::indexOf);
            List childrenAfterFirstNonConstructor = indexOfFirstNonConstructor.map(index -> children.subList((int)index, children.size())).orElseGet(ArrayList::new);
            List<DetailAST> constructorsToLog = childrenAfterFirstNonConstructor.stream().filter(ConstructorsDeclarationGroupingCheck::isConstructor).toList();
            DetailAST lastGroupedConstructor = childrenAfterFirstConstructor.stream().takeWhile(ConstructorsDeclarationGroupingCheck::isConstructor).reduce((first, second) -> second).orElse(firstConstructor);
            constructorsToLog.forEach(ctor -> this.log((DetailAST)ctor, MSG_KEY, (Object)lastGroupedConstructor.getLineNo()));
        }
    }

    private static List<DetailAST> getChildList(DetailAST ast) {
        ArrayList<DetailAST> children = new ArrayList<DetailAST>();
        for (DetailAST child = ast.findFirstToken(6).getFirstChild(); child != null; child = child.getNextSibling()) {
            children.add(child);
        }
        return children;
    }

    private static boolean isConstructor(DetailAST ast) {
        return ast.getType() == 8 || ast.getType() == 203;
    }
}

