/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocContentLocationOption;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.Locale;

@StatelessCheck
public class JavadocContentLocationCheck
extends AbstractCheck {
    public static final String MSG_JAVADOC_CONTENT_FIRST_LINE = "javadoc.content.first.line";
    public static final String MSG_JAVADOC_CONTENT_SECOND_LINE = "javadoc.content.second.line";
    private JavadocContentLocationOption location = JavadocContentLocationOption.SECOND_LINE;

    @Override
    public int[] getRequiredTokens() {
        return new int[]{145};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    public void setLocation(String value) {
        this.location = JavadocContentLocationOption.valueOf(value.trim().toUpperCase(Locale.ENGLISH));
    }

    @Override
    public void visitToken(DetailAST ast) {
        String commentContent;
        int indexOfFirstNonBlankLine;
        if (JavadocContentLocationCheck.isMultilineComment(ast) && JavadocUtil.isJavadocComment(ast) && (indexOfFirstNonBlankLine = JavadocContentLocationCheck.findIndexOfFirstNonBlankLine(commentContent = JavadocUtil.getJavadocCommentContent(ast))) >= 0) {
            if (this.location == JavadocContentLocationOption.FIRST_LINE && indexOfFirstNonBlankLine != 0) {
                this.log(ast, MSG_JAVADOC_CONTENT_FIRST_LINE, new Object[0]);
            } else if (this.location == JavadocContentLocationOption.SECOND_LINE && indexOfFirstNonBlankLine != 1) {
                this.log(ast, MSG_JAVADOC_CONTENT_SECOND_LINE, new Object[0]);
            }
        }
    }

    private static boolean isMultilineComment(DetailAST node) {
        return !TokenUtil.areOnSameLine(node, node.getLastChild());
    }

    private static int findIndexOfFirstNonBlankLine(String commentContent) {
        int lineNo = 0;
        boolean noContent = true;
        for (int i = 0; i < commentContent.length(); ++i) {
            char character = commentContent.charAt(i);
            if (character == '\n') {
                ++lineNo;
                continue;
            }
            if (character == '*' || Character.isWhitespace(character)) continue;
            noContent = false;
            break;
        }
        if (noContent) {
            lineNo = -1;
        }
        return lineNo;
    }
}

