//[okio](../../../index.md)/[okio](../index.md)/[Buffer](index.md)/[emitCompleteSegments](emit-complete-segments.md)

# emitCompleteSegments

[common]\
expect open override fun [emitCompleteSegments](emit-complete-segments.md)(): [Buffer](index.md)

Writes complete segments to the underlying sink, if one exists. Like [flush](index.md#164302971%2FFunctions%2F1348982416), but weaker. Use this to limit the memory held in the buffer to a single segment. Typically application code will not need to call this: it is only necessary when application code writes directly to this [sink's buffer](../buffer.md).

```java
BufferedSink b0 = new Buffer();
BufferedSink b1 = Okio.buffer(b0);
BufferedSink b2 = Okio.buffer(b1);

b2.buffer().write(new byte[20_000]);
assertEquals(20_000, b2.buffer().size());
assertEquals(     0, b1.buffer().size());
assertEquals(     0, b0.buffer().size());

b2.emitCompleteSegments();
assertEquals( 3_616, b2.buffer().size());
assertEquals(     0, b1.buffer().size());
assertEquals(16_384, b0.buffer().size()); // This example assumes 8192 byte segments.
```

[jvm, nonJvm]\
[jvm, nonJvm]\
actual open override fun [emitCompleteSegments](emit-complete-segments.md)(): [Buffer](index.md)
