//[okio](../../../index.md)/[okio](../index.md)/[InflaterSource](index.md)

# InflaterSource

[zlib]\
expect class [InflaterSource](index.md) : [Source](../-source/index.md#1331753033%2FMain%2F-1717108311)

A source that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to decompress data read from another source.

## Constructors

| | |
|---|---|
| [InflaterSource](-inflater-source.md) | [zlib]<br>expect constructor(source: [Source](../-source/index.md#1331753033%2FMain%2F-1717108311), inflater: [Inflater](../-inflater/index.md)) |

## Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md) | [common]<br>fun [Source](../-source/index.md).[buffer](../buffer.md)(): [BufferedSource](../-buffered-source/index.md)<br>Returns a new source that buffers reads from `source`. The returned source will perform bulk reads into its in-memory buffer. Use this wherever you read a source to get an ergonomic and efficient access to data. |
| [cipherSource](../cipher-source.md) | [jvm]<br>fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[cipherSource](../cipher-source.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSource](../-cipher-source/index.md)<br>Returns a source that uses [cipher](../cipher-source.md) to encrypt or decrypt this. |
| [close](index.md#-267757364%2FFunctions%2F-1717108311) | [zlib]<br>abstract override fun [close](index.md#-267757364%2FFunctions%2F-1717108311)()<br>Closes this source and releases the resources held by this source. It is an error to read a closed source. It is safe to close a source more than once. |
| [gzip](../gzip.md) | [zlib]<br>inline fun [Source](../-source/index.md#1331753033%2FMain%2F-1717108311).[gzip](../gzip.md)(): [GzipSource](../-gzip-source/index.md)<br>Returns a [GzipSource](../-gzip-source/index.md) that gzip-decompresses this [Source](../-source/index.md#1331753033%2FMain%2F-1717108311) while reading. |
| [hashingSource](../hashing-source.md) | [jvm]<br>fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[hashingSource](../hashing-source.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSource](../-hashing-source/index.md)<br>Returns a source that uses [digest](../hashing-source.md) to hash this.<br>[jvm]<br>fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[hashingSource](../hashing-source.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSource](../-hashing-source/index.md)<br>Returns a source that uses [mac](../hashing-source.md) to hash this. |
| [inflate](../inflate.md) | [zlib]<br>inline fun [Source](../-source/index.md#1331753033%2FMain%2F-1717108311).[inflate](../inflate.md)(inflater: [Inflater](../-inflater/index.md) = Inflater()): [InflaterSource](index.md)<br>Returns an [InflaterSource](index.md) that DEFLATE-decompresses this [Source](../-source/index.md#1331753033%2FMain%2F-1717108311) while reading. |
| [read](index.md#-934028336%2FFunctions%2F-1717108311) | [zlib]<br>abstract fun [read](index.md#-934028336%2FFunctions%2F-1717108311)(sink: [Buffer](../-buffer/index.md#-987215932%2FMain%2F-1717108311), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes at least 1, and up to `byteCount` bytes from this and appends them to `sink`. Returns the number of bytes read, or -1 if this source is exhausted. |
| [timeout](index.md#665058243%2FFunctions%2F-1717108311) | [zlib]<br>abstract fun [timeout](index.md#665058243%2FFunctions%2F-1717108311)(): Timeout<br>Returns the timeout for this source. |
