/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.UnaryOperator;
import net.fabricmc.loom.util.ExceptionUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public final class ClassVisitorUtil {
    public static void rewriteClassFile(Path path, UnaryOperator<ClassVisitor> visitorFactory) throws IOException {
        try {
            byte[] inputBytes = Files.readAllBytes(path);
            ClassReader reader = new ClassReader(inputBytes);
            ClassWriter writer = new ClassWriter(0);
            reader.accept((ClassVisitor)visitorFactory.apply((ClassVisitor)writer), 0);
            byte[] outputBytes = writer.toByteArray();
            if (!Arrays.equals(inputBytes, outputBytes)) {
                Files.write(path, outputBytes, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw ExceptionUtil.createDescriptiveWrapper(IOException::new, "Failed to patch " + path, e);
        }
    }
}

