/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.util;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.StringJoiner;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.util.FileSystemUtil;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.jetbrains.annotations.Nullable;

public final class ForgeLoggerConfig {
    private static final List<ArtifactCoordinates> LOGGER_CONFIG_ARTIFACTS = List.of(new ArtifactCoordinates("net.minecraftforge", "fmlloader", null), new ArtifactCoordinates("net.minecraftforge", "forge", "launcher"));

    public static void copyToPath(Project project, Path outputFile) {
        try {
            Files.deleteIfExists(outputFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        List<String> libraries = LoomGradleExtension.get(project).getForgeUserdevProvider().getConfig().libraries();
        boolean found = false;
        for (String library : libraries) {
            if (!LOGGER_CONFIG_ARTIFACTS.stream().anyMatch(artifact -> artifact.matches(library))) continue;
            File libraryFile = project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().create((Object)library)}).setTransitive(false).getSingleFile();
            try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(libraryFile, false);){
                Path configPath = fs.getPath("log4j2.xml", new String[0]);
                Files.copy(configPath, outputFile, new CopyOption[0]);
                found = true;
                break;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (!found) {
            StringBuilder sb = new StringBuilder("Could not find Forge dependency with logger config. Tried to find:");
            for (ArtifactCoordinates artifact2 : LOGGER_CONFIG_ARTIFACTS) {
                sb.append('\n').append(" - ").append(artifact2);
            }
            throw new RuntimeException(sb.toString());
        }
    }

    private record ArtifactCoordinates(String group, String name, @Nullable String classifier) {
        boolean matches(String notation) {
            String[] parts = notation.split(":");
            return this.group.equals(parts[0]) && this.name.equals(parts[1]) && (this.classifier == null || parts.length >= 4 && this.classifier.equals(parts[3]));
        }

        @Override
        public String toString() {
            StringJoiner joiner = new StringJoiner(":");
            joiner.add(this.group);
            joiner.add(this.name);
            if (this.classifier != null) {
                joiner.add(this.classifier);
            }
            return joiner.toString();
        }
    }
}

