/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.util;

import net.fabricmc.loom.api.LoomGradleExtensionAPI;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.util.ModPlatform;

public enum MappingOption {
    DEFAULT(null),
    WITH_SRG(MappingsNamespace.SRG.toString()),
    WITH_MOJANG(MappingsNamespace.MOJANG.toString());

    private final String extraNamespace;

    private MappingOption(String extraNamespace) {
        this.extraNamespace = extraNamespace;
    }

    public MappingOption forNamespaces(String ... namespaces) {
        if (this.extraNamespace == null) {
            return this;
        }
        for (String namespace : namespaces) {
            if (!this.extraNamespace.equals(namespace)) continue;
            return this;
        }
        return DEFAULT;
    }

    public static MappingOption forPlatform(LoomGradleExtensionAPI extension) {
        return switch ((ModPlatform)((Object)extension.getPlatform().get())) {
            case ModPlatform.FORGE -> WITH_SRG;
            case ModPlatform.NEOFORGE -> WITH_MOJANG;
            default -> DEFAULT;
        };
    }
}

