/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.build.nesting;

import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.util.ModPlatform;
import net.fabricmc.loom.util.Pair;
import net.fabricmc.loom.util.ZipReprocessorUtil;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IncludedJarFactory {
    private final Project project;
    private static final Logger LOGGER = LoggerFactory.getLogger(IncludedJarFactory.class);
    private static final String SEMVER_REGEX = "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$";
    private static final Pattern SEMVER_PATTERN = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");

    public IncludedJarFactory(Project project) {
        this.project = project;
    }

    public Provider<ConfigurableFileCollection> getNestedJars(Configuration configuration) {
        return this.project.provider(() -> {
            ConfigurableFileCollection files = this.project.files(new Object[0]);
            HashSet visited = Sets.newHashSet();
            HashSet builtBy = Sets.newHashSet();
            files.from(this.getProjectDeps(configuration, visited, builtBy).stream().map(LazyNestedFile::file).toArray());
            files.from(this.getFileDeps(configuration, visited, builtBy).stream().map(LazyNestedFile::file).toArray());
            files.builtBy(new Object[]{configuration.getBuildDependencies()});
            return files;
        });
    }

    public Provider<Pair<List<LazyNestedFile>, TaskDependency>> getForgeNestedJars(Configuration configuration) {
        return this.project.provider(() -> {
            ArrayList<LazyNestedFile> files = new ArrayList<LazyNestedFile>();
            HashSet visited = Sets.newHashSet();
            HashSet builtBy = Sets.newHashSet();
            files.addAll(this.getProjectDeps(configuration, visited, builtBy));
            files.addAll(this.getFileDeps(configuration, visited, builtBy));
            return new Pair(files, task -> {
                TaskDependency dependencies = configuration.getBuildDependencies();
                HashSet tasks = new HashSet(dependencies.getDependencies(task));
                tasks.addAll(builtBy);
                return tasks;
            });
        });
    }

    private List<LazyNestedFile> getFileDeps(Configuration configuration, Set<String> visited, Set<Task> builtBy) {
        ArrayList<LazyNestedFile> files = new ArrayList<LazyNestedFile>();
        ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
        Set dependencies = resolvedConfiguration.getFirstLevelModuleDependencies();
        for (ResolvedDependency dependency : dependencies) {
            if (!visited.add(dependency.getModuleGroup() + ":" + dependency.getModuleName() + ":" + dependency.getModuleVersion())) continue;
            for (ResolvedArtifact artifact : dependency.getModuleArtifacts()) {
                Metadata metadata = new Metadata(dependency.getModuleGroup(), dependency.getModuleName(), dependency.getModuleVersion(), artifact.getClassifier());
                files.add(new LazyNestedFile(this.project, metadata, () -> this.getNestableJar(artifact.getFile(), metadata)));
            }
        }
        return files;
    }

    private List<LazyNestedFile> getProjectDeps(Configuration configuration, Set<String> visited, Set<Task> builtBy) {
        ArrayList<LazyNestedFile> files = new ArrayList<LazyNestedFile>();
        for (Dependency dependency : configuration.getDependencies()) {
            if (!(dependency instanceof ProjectDependency)) continue;
            ProjectDependency projectDependency = (ProjectDependency)dependency;
            if (!visited.add(dependency.getGroup() + ":" + dependency.getName() + ":" + dependency.getVersion())) continue;
            Project dependentProject = projectDependency.getDependencyProject();
            Set remapJarTasks = dependentProject.getTasksByName("remapJar", false);
            Set jarTasks = dependentProject.getTasksByName("jar", false);
            if (remapJarTasks.isEmpty() && jarTasks.isEmpty()) {
                throw new UnsupportedOperationException("%s does not have a remapJar or jar task, cannot nest it".formatted(dependentProject.getName()));
            }
            for (Task task : remapJarTasks.isEmpty() ? jarTasks : remapJarTasks) {
                if (task instanceof AbstractArchiveTask) {
                    AbstractArchiveTask archiveTask = (AbstractArchiveTask)task;
                    Metadata metadata = new Metadata(projectDependency.getGroup(), projectDependency.getName(), projectDependency.getVersion(), (String)archiveTask.getArchiveClassifier().getOrNull());
                    Provider provider = archiveTask.getArchiveFile().map(regularFile -> this.getNestableJar(regularFile.getAsFile(), metadata));
                    files.add(new LazyNestedFile(metadata, (Provider<File>)provider));
                    builtBy.add(task);
                    continue;
                }
                throw new UnsupportedOperationException("Cannot nest none AbstractArchiveTask task: " + task.getName());
            }
        }
        return files;
    }

    private File getNestableJar(File input, Metadata metadata) {
        File tempFile;
        if (FabricModJsonFactory.isNestableModJar(input, (ModPlatform)((Object)LoomGradleExtension.get(this.project).getPlatform().get()))) {
            return input;
        }
        LoomGradleExtension extension = LoomGradleExtension.get(this.project);
        String childName = "temp/modprocessing/%s/%s/%s/%s".formatted(metadata.group().replace(".", "/"), metadata.name(), metadata.version(), input.getName());
        File tempDir = new File(extension.getFiles().getProjectBuildCache(), childName);
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        if ((tempFile = new File(tempDir, input.getName())).exists() && FabricModJsonFactory.isModJar(tempFile, (ModPlatform)((Object)LoomGradleExtension.get(this.project).getPlatform().get()))) {
            return tempFile;
        }
        try {
            FileUtils.copyFile((File)input, (File)tempFile);
            ZipReprocessorUtil.appendZipEntry(tempFile.toPath(), "fabric.mod.json", IncludedJarFactory.generateModForDependency(metadata).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to add dummy mod while including %s".formatted(input), e);
        }
        return tempFile;
    }

    private static String generateModForDependency(Metadata metadata) {
        Object modId = (metadata.group() + "_" + metadata.name() + metadata.classifier()).replaceAll("\\.", "_").toLowerCase(Locale.ENGLISH);
        if (((String)modId).length() > 64) {
            String hash = Hashing.sha256().hashString((CharSequence)modId, StandardCharsets.UTF_8).toString();
            modId = ((String)modId).substring(0, 50) + hash.substring(0, 14);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("schemaVersion", (Number)1);
        jsonObject.addProperty("id", (String)modId);
        String version = IncludedJarFactory.getVersion(metadata);
        jsonObject.addProperty("version", version);
        jsonObject.addProperty("name", metadata.name());
        JsonObject custom = new JsonObject();
        custom.addProperty("fabric-loom:generated", Boolean.valueOf(true));
        jsonObject.add("custom", (JsonElement)custom);
        return LoomGradlePlugin.GSON.toJson((JsonElement)jsonObject);
    }

    private static String getVersion(Metadata metadata) {
        String trimmedVersion;
        String version = metadata.version();
        if (IncludedJarFactory.validSemVer(version)) {
            return version;
        }
        if ((version.endsWith(".Final") || version.endsWith(".final")) && IncludedJarFactory.validSemVer(trimmedVersion = version.substring(0, version.length() - 6))) {
            return trimmedVersion;
        }
        LOGGER.warn("({}) is not valid semver for dependency {}", (Object)version, (Object)metadata);
        return version;
    }

    private static boolean validSemVer(String version) {
        Matcher matcher = SEMVER_PATTERN.matcher(version);
        return matcher.find();
    }

    public record Metadata(String group, String name, String version, @Nullable String classifier) implements Serializable
    {
        @Nullable
        private final String classifier;

        public String classifier() {
            if (this.classifier == null) {
                return "";
            }
            return "_" + this.classifier;
        }

        @Override
        public String toString() {
            return this.group + ":" + this.name + ":" + this.version + this.classifier();
        }
    }

    public record LazyNestedFile(Metadata metadata, Provider<File> file) implements Serializable
    {
        public LazyNestedFile(Project project, Metadata metadata, Supplier<File> file) {
            this(metadata, (Provider<File>)project.provider(file::get));
        }

        public NestedFile resolve() {
            return new NestedFile(this.metadata, (File)this.file.get());
        }
    }

    public record NestedFile(Metadata metadata, File file) implements Serializable
    {
    }
}

