/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.build.nesting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.build.nesting.IncludedJarFactory;
import net.fabricmc.loom.util.ModPlatform;
import net.fabricmc.loom.util.Pair;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import org.slf4j.Logger;

public class JarNester {
    public static void nestJars(Collection<File> jars, List<IncludedJarFactory.NestedFile> forgeJars, File modJar, ModPlatform platform, Logger logger) {
        if (jars.isEmpty()) {
            logger.debug("Nothing to nest into " + modJar.getName());
            return;
        }
        Preconditions.checkArgument((boolean)FabricModJsonFactory.isNestableModJar(modJar, platform), (Object)("Cannot nest jars into none mod jar " + modJar.getName()));
        try {
            ZipUtils.add(modJar.toPath(), jars.stream().map(file -> {
                try {
                    return new Pair<CallSite, byte[]>((CallSite)((Object)("META-INF/jars/" + file.getName())), Files.readAllBytes(file.toPath()));
                }
                catch (IOException e) {
                    throw new org.gradle.api.UncheckedIOException((Throwable)e);
                }
            }).collect(Collectors.toList()));
            if (platform.isForgeLike()) {
                JarNester.handleForgeJarJar(forgeJars, modJar, logger);
                return;
            }
            int count = ZipUtils.transformJson(JsonObject.class, modJar.toPath(), Stream.of(platform == ModPlatform.FABRIC ? new Pair<String, ZipUtils.UnsafeUnaryOperator<JsonObject>>("fabric.mod.json", json -> {
                JsonArray nestedJars = json.getAsJsonArray("jars");
                if (nestedJars == null || !json.has("jars")) {
                    nestedJars = new JsonArray();
                }
                for (File file : jars) {
                    String nestedJarPath = "META-INF/jars/" + file.getName();
                    Preconditions.checkArgument((boolean)FabricModJsonFactory.isNestableModJar(file, platform), (Object)("Cannot nest none mod jar: " + file.getName()));
                    for (JsonElement nestedJar : nestedJars) {
                        JsonObject jsonObject = nestedJar.getAsJsonObject();
                        if (!jsonObject.has("file") || !jsonObject.get("file").getAsString().equals(nestedJarPath)) continue;
                        throw new IllegalStateException("Cannot nest 2 jars at the same path: " + nestedJarPath);
                    }
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("file", nestedJarPath);
                    nestedJars.add((JsonElement)jsonObject);
                    logger.debug("Nested " + nestedJarPath + " into " + modJar.getName());
                }
                json.add("jars", (JsonElement)nestedJars);
                return json;
            }) : (platform == ModPlatform.QUILT ? new Pair<String, ZipUtils.UnsafeUnaryOperator<JsonObject>>("quilt.mod.json", json -> {
                JsonObject loader;
                if (json.has("quilt_loader")) {
                    loader = json.getAsJsonObject("quilt_loader");
                } else {
                    loader = new JsonObject();
                    json.add("quilt_loader", (JsonElement)loader);
                }
                JsonArray nestedJars = loader.getAsJsonArray("jars");
                if (nestedJars == null || !loader.has("jars")) {
                    nestedJars = new JsonArray();
                }
                for (File file : jars) {
                    String nestedJarPath = "META-INF/jars/" + file.getName();
                    Preconditions.checkArgument((boolean)FabricModJsonFactory.isNestableModJar(file, platform), (Object)("Cannot nest none mod jar: " + file.getName()));
                    for (JsonElement nestedJar : nestedJars) {
                        String nestedJarString = nestedJar.getAsString();
                        if (!nestedJarPath.equals(nestedJarString)) continue;
                        throw new IllegalStateException("Cannot nest 2 jars at the same path: " + nestedJarString);
                    }
                    nestedJars.add(nestedJarPath);
                    logger.debug("Nested " + nestedJarPath + " into " + modJar.getName());
                }
                loader.add("jars", (JsonElement)nestedJars);
                return json;
            }) : null)));
            Preconditions.checkState((count > 0 ? 1 : 0) != 0, (Object)"Failed to transform fabric.mod.json");
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to nest jars into " + modJar.getName(), e);
        }
    }

    private static void handleForgeJarJar(List<IncludedJarFactory.NestedFile> forgeJars, File modJar, Logger logger) throws IOException {
        JsonObject json = new JsonObject();
        JsonArray nestedJars = new JsonArray();
        for (IncludedJarFactory.NestedFile nestedFile : forgeJars) {
            IncludedJarFactory.Metadata metadata = nestedFile.metadata();
            File file = nestedFile.file();
            String nestedJarPath = "META-INF/jars/" + file.getName();
            for (JsonElement nestedJar : nestedJars) {
                JsonObject jsonObject = nestedJar.getAsJsonObject();
                if (!jsonObject.has("path") || !jsonObject.get("path").getAsString().equals(nestedJarPath)) continue;
                throw new IllegalStateException("Cannot nest 2 jars at the same path: " + nestedJarPath);
            }
            JsonObject jsonObject = new JsonObject();
            JsonObject identifierObject = new JsonObject();
            JsonObject versionObject = new JsonObject();
            identifierObject.addProperty("group", metadata.group());
            identifierObject.addProperty("artifact", metadata.name());
            versionObject.addProperty("range", "[" + metadata.version() + ",)");
            versionObject.addProperty("artifactVersion", metadata.version());
            jsonObject.add("identifier", (JsonElement)identifierObject);
            jsonObject.add("version", (JsonElement)versionObject);
            jsonObject.addProperty("path", nestedJarPath);
            nestedJars.add((JsonElement)jsonObject);
            logger.debug("Nested " + nestedJarPath + " into " + modJar.getName());
        }
        json.add("jars", (JsonElement)nestedJars);
        ZipUtils.add(modJar.toPath(), "META-INF/jarjar/metadata.json", LoomGradlePlugin.GSON.toJson((JsonElement)json));
    }
}

