/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.accesswidener;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.architectury.loom.metadata.ModMetadataFile;
import dev.architectury.loom.metadata.ModMetadataFiles;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.function.CollectionUtil;

public record AccessWidenerFile(String path, String modId, byte[] content) {
    public static AccessWidenerFile fromModJar(Path modJarPath) {
        byte[] content;
        byte[] modJsonBytes;
        try {
            modJsonBytes = ZipUtils.unpackNullable(modJarPath, "fabric.mod.json");
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read access-widener file from: " + modJarPath.toAbsolutePath(), e);
        }
        if (modJsonBytes == null) {
            byte[] content2;
            String awPath;
            ModMetadataFile modMetadata;
            block13: {
                try {
                    modMetadata = ModMetadataFiles.fromJar(modJarPath);
                    if (modMetadata != null) {
                        Set<String> accessWideners = modMetadata.getAccessWideners();
                        if (accessWideners.size() > 1) {
                            throw new UnsupportedOperationException("Cannot read multiple access wideners from " + modJarPath);
                        }
                        awPath = CollectionUtil.single(modMetadata.getAccessWideners()).orElse(null);
                        if (awPath == null) {
                            return null;
                        }
                        break block13;
                    }
                    return null;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Could not read mod metadata from " + modJarPath.toAbsolutePath(), e);
                }
            }
            try {
                content2 = ZipUtils.unpack(modJarPath, awPath);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not find access widener file (%s) defined in the %s file of %s".formatted(awPath, modMetadata.getFileName(), modJarPath.toAbsolutePath()), e);
            }
            return new AccessWidenerFile(awPath, Objects.requireNonNullElseGet(modMetadata.getId(), () -> modJarPath.getFileName().toString()), content2);
        }
        JsonObject jsonObject = (JsonObject)new Gson().fromJson(new String(modJsonBytes, StandardCharsets.UTF_8), JsonObject.class);
        if (!jsonObject.has("accessWidener")) {
            return null;
        }
        String awPath = jsonObject.get("accessWidener").getAsString();
        String modId = jsonObject.get("id").getAsString();
        try {
            content = ZipUtils.unpack(modJarPath, awPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not find access widener file (%s) defined in the fabric.mod.json file of %s".formatted(awPath, modJarPath.toAbsolutePath()), e);
        }
        return new AccessWidenerFile(awPath, modId, content);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.path, this.modId);
        result = 31 * result + Arrays.hashCode(this.content);
        return result;
    }
}

