/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.ide.idea;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ide.RunConfig;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.configuration.ide.idea.IdeaUtils;
import net.fabricmc.loom.task.AbstractLoomTask;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.VisibleForTesting;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class IdeaSyncTask
extends AbstractLoomTask {
    @Inject
    public IdeaSyncTask() {
        this.getOutputs().upToDateWhen(element -> false);
        this.setGroup("ide");
    }

    @TaskAction
    public void runTask() throws IOException {
        File projectDir = this.getProject().getRootProject().file((Object)".idea");
        projectDir.mkdirs();
        this.generateRunConfigs();
    }

    private void generateRunConfigs() throws IOException {
        Project rootProject = this.getProject().getRootProject();
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        String projectPath = this.getProject() == rootProject ? "" : this.getProject().getPath().replace(':', '_');
        File runConfigsDir = new File(rootProject.file((Object)".idea"), "runConfigurations");
        if (!runConfigsDir.exists()) {
            runConfigsDir.mkdirs();
        }
        for (RunConfigSettings settings : extension.getRunConfigs()) {
            if (!settings.isIdeConfigGenerated()) continue;
            RunConfig config = RunConfig.runConfig(this.getProject(), settings);
            String name = config.configName.replaceAll("[^a-zA-Z0-9$_]", "_");
            File runConfigs = new File(runConfigsDir, name + projectPath + ".xml");
            String runConfigXml = config.fromDummy("idea_run_config_template.xml", true, this.getProject());
            if (!runConfigs.exists()) {
                FileUtils.writeStringToFile((File)runConfigs, (String)runConfigXml, (Charset)StandardCharsets.UTF_8);
            }
            settings.makeRunDir();
            List<String> excludedLibraryPaths = config.getExcludedLibraryPaths(this.getProject());
            try {
                this.setClasspathModifications(runConfigs.toPath(), excludedLibraryPaths);
            }
            catch (Exception e) {
                this.getProject().getLogger().error("Failed to modify run configuration xml", (Throwable)e);
            }
        }
    }

    private void setClasspathModifications(Path runConfig, List<String> exclusions) throws IOException {
        String outputXml;
        if (!IdeaUtils.supportsCustomizableClasspath()) {
            return;
        }
        String inputXml = Files.readString(runConfig, StandardCharsets.UTF_8);
        try {
            outputXml = IdeaSyncTask.setClasspathModificationsInXml(inputXml, exclusions);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to modify idea xml", (Throwable)e);
            return;
        }
        if (!inputXml.equals(outputXml)) {
            Files.writeString(runConfig, (CharSequence)outputXml, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    @VisibleForTesting
    public static String setClasspathModificationsInXml(String input, List<String> exclusions) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(input)));
        Element root = document.getDocumentElement();
        NodeList nodeList = root.getElementsByTagName("configuration");
        assert (nodeList.getLength() == 1);
        Element configuration = (Element)nodeList.item(0);
        NodeList classpathModificationsList = configuration.getElementsByTagName("classpathModifications");
        for (int i = 0; i < classpathModificationsList.getLength(); ++i) {
            configuration.removeChild(classpathModificationsList.item(i));
        }
        Element classpathModifications = document.createElement("classpathModifications");
        for (String exclusionPath : exclusions) {
            Element exclusion = document.createElement("entry");
            exclusion.setAttribute("exclude", "true");
            exclusion.setAttribute("path", exclusionPath);
            classpathModifications.appendChild(exclusion);
        }
        configuration.appendChild(classpathModifications);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        transformer.transform(source, new StreamResult(writer));
        return writer.toString().replace("\r", "");
    }
}

