/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge;

import com.mojang.serialization.Codec;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ConfigValue {
    public static final String OUTPUT = "output";
    public static final String PREVIOUS_OUTPUT_SUFFIX = "Output";
    public static final String LOG = "log";
    public static final Codec<ConfigValue> CODEC = Codec.STRING.xmap(ConfigValue::of, configValue -> {
        if (configValue instanceof Constant) {
            Constant constant = (Constant)configValue;
            return constant.value();
        }
        if (configValue instanceof Variable) {
            Variable variable = (Variable)configValue;
            return "{" + variable.name() + "}";
        }
        throw new IllegalArgumentException("Unmatched config value");
    });

    public String resolve(Resolver var1);

    public static ConfigValue of(String str) {
        if (str.startsWith("{") && str.endsWith("}")) {
            return new Variable(str.substring(1, str.length() - 1));
        }
        return new Constant(str);
    }

    public record Variable(String name) implements ConfigValue
    {
        @Override
        public String resolve(Resolver variableResolver) {
            return variableResolver.resolve(this);
        }
    }

    public record Constant(String value) implements ConfigValue
    {
        @Override
        public String resolve(Resolver variableResolver) {
            return this.value;
        }
    }

    @FunctionalInterface
    public static interface Resolver {
        public String resolve(Variable var1);
    }
}

