/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge;

import java.io.File;
import java.nio.file.Path;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.configuration.providers.forge.DependencyProvider;
import net.fabricmc.loom.util.LoomVersions;
import net.fabricmc.loom.util.ModPlatform;
import org.gradle.api.Project;

public class ForgeProvider
extends DependencyProvider {
    private final ModPlatform platform;
    private ForgeVersion version = new ForgeVersion(null);
    private File globalCache;

    public ForgeProvider(Project project) {
        super(project);
        this.platform = (ModPlatform)((Object)this.getExtension().getPlatform().get());
    }

    @Override
    public void provide(DependencyInfo dependency) throws Exception {
        this.version = new ForgeVersion(dependency.getResolvedVersion());
        this.addDependency(dependency.getDepString() + ":userdev", "forgeUserdev");
        this.addDependency(dependency.getDepString() + ":installer", "forgeInstaller");
        if (this.getExtension().isForge() && this.version.getMajorVersion() >= 49) {
            this.addDependency(LoomVersions.UNION_RELAUNCHER.mavenNotation(), "forgeExtra");
        }
    }

    public ForgeVersion getVersion() {
        return this.version;
    }

    public File getGlobalCache() {
        if (this.globalCache == null) {
            this.globalCache = this.getMinecraftProvider().dir(this.platform.id() + "/" + this.version.getCombined());
            this.globalCache.mkdirs();
        }
        return this.globalCache;
    }

    @Override
    public String getTargetConfig() {
        return this.platform == ModPlatform.NEOFORGE ? "neoForge" : "forge";
    }

    public static Path getForgeCache(Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        ModPlatform platform = (ModPlatform)((Object)extension.getPlatform().get());
        String version = extension.getForgeProvider().getVersion().getCombined();
        return LoomGradleExtension.get(project).getMinecraftProvider().dir(platform.id() + "/" + version).toPath();
    }

    public static final class ForgeVersion {
        private final String combined;
        private final String minecraftVersion;
        private final String forgeVersion;
        private final int majorVersion;

        public ForgeVersion(String combined) {
            int major;
            this.combined = combined;
            if (combined == null) {
                this.minecraftVersion = "NO_VERSION";
                this.forgeVersion = "NO_VERSION";
                this.majorVersion = -1;
                return;
            }
            int hyphenIndex = combined.indexOf(45);
            if (hyphenIndex != -1) {
                this.minecraftVersion = combined.substring(0, hyphenIndex);
                this.forgeVersion = combined.substring(hyphenIndex + 1);
            } else {
                this.minecraftVersion = "NO_VERSION";
                this.forgeVersion = combined;
            }
            int dotIndex = this.forgeVersion.indexOf(46);
            try {
                major = dotIndex >= 0 ? Integer.parseInt(this.forgeVersion.substring(0, dotIndex)) : Integer.parseInt(this.forgeVersion);
            }
            catch (NumberFormatException e) {
                major = -1;
            }
            this.majorVersion = major;
        }

        public String getCombined() {
            return this.combined;
        }

        public String getMinecraftVersion() {
            return this.minecraftVersion;
        }

        public String getForgeVersion() {
            return this.forgeVersion;
        }

        public int getMajorVersion() {
            return this.majorVersion;
        }
    }
}

