/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.configuration.providers.forge.ConfigValue;
import net.fabricmc.loom.configuration.providers.forge.ForgeProvider;
import net.fabricmc.loom.util.function.CollectionUtil;
import org.gradle.api.Named;

public record ForgeRunTemplate(String name, String main, List<ConfigValue> args, List<ConfigValue> jvmArgs, Map<String, ConfigValue> env, Map<String, ConfigValue> props) implements Named
{
    public static final Codec<ForgeRunTemplate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("name", (Object)"").forGetter(ForgeRunTemplate::name), (App)Codec.STRING.fieldOf("main").forGetter(ForgeRunTemplate::main), (App)ConfigValue.CODEC.listOf().optionalFieldOf("args", List.of()).forGetter(ForgeRunTemplate::args), (App)ConfigValue.CODEC.listOf().optionalFieldOf("jvmArgs", List.of()).forGetter(ForgeRunTemplate::jvmArgs), (App)Codec.unboundedMap((Codec)Codec.STRING, ConfigValue.CODEC).optionalFieldOf("env", Map.of()).forGetter(ForgeRunTemplate::env), (App)Codec.unboundedMap((Codec)Codec.STRING, ConfigValue.CODEC).optionalFieldOf("props", Map.of()).forGetter(ForgeRunTemplate::props)).apply((Applicative)instance, ForgeRunTemplate::new));
    public static final Codec<Map<String, ForgeRunTemplate>> MAP_CODEC = Codec.unboundedMap((Codec)Codec.STRING, CODEC).xmap(map -> {
        HashMap newMap = new HashMap(map);
        for (Map.Entry entry : newMap.entrySet()) {
            ForgeRunTemplate template = (ForgeRunTemplate)entry.getValue();
            if (!template.name.isEmpty()) continue;
            ForgeRunTemplate completed = new ForgeRunTemplate((String)entry.getKey(), template.main, template.args, template.jvmArgs, template.env, template.props);
            entry.setValue(completed);
        }
        return newMap;
    }, Function.identity());

    public String getName() {
        return this.name;
    }

    public void applyTo(RunConfigSettings settings, ConfigValue.Resolver configValueResolver) {
        if (settings.getDefaultMainClass().equals("[Forge] Main class has not been determined yet!")) {
            settings.defaultMainClass(this.main);
        }
        settings.vmArgs(CollectionUtil.map(this.jvmArgs, value -> value.resolve(configValueResolver)));
        this.env.forEach((key, value) -> {
            String resolved = value.resolve(configValueResolver);
            settings.getEnvironmentVariables().putIfAbsent((String)key, resolved);
        });
        settings.getEnvironmentVariables().computeIfAbsent("MOD_CLASSES", $ -> ConfigValue.of("{source_roots}").resolve(configValueResolver));
        ForgeProvider forgeProvider = settings.getExtension().getForgeProvider();
        if (settings.getExtension().isForge() && forgeProvider.getVersion().getMajorVersion() >= 49) {
            settings.defaultMainClass("juuxel.unionrelauncher.UnionRelauncher");
            settings.property("unionRelauncher.mainClass", this.main);
        }
    }
}

