/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.loom.forge.UserdevConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.ModSettings;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.configuration.providers.forge.ConfigValue;
import net.fabricmc.loom.configuration.providers.forge.ForgeRunTemplate;
import net.fabricmc.loom.configuration.providers.forge.ForgeUserdevProvider;
import net.fabricmc.loom.util.DependencyDownloader;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import net.fabricmc.loom.util.gradle.SourceSetReference;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Project;
import org.jetbrains.annotations.Nullable;

public class ForgeRunsProvider {
    private final Project project;
    private final LoomGradleExtension extension;
    private final JsonObject json;
    private final NamedDomainObjectSet<ForgeRunTemplate> templates;

    public ForgeRunsProvider(Project project, JsonObject json, UserdevConfig userdevConfig) {
        this.project = project;
        this.extension = LoomGradleExtension.get(project);
        this.json = json;
        this.templates = project.getObjects().namedDomainObjectSet(ForgeRunTemplate.class);
        this.templates.addAll(userdevConfig.runs().values());
    }

    public NamedDomainObjectSet<ForgeRunTemplate> getTemplates() {
        return this.templates;
    }

    public static ForgeRunsProvider create(Project project) {
        ForgeUserdevProvider userdevProvider = LoomGradleExtension.get(project).getForgeUserdevProvider();
        return new ForgeRunsProvider(project, userdevProvider.getJson(), userdevProvider.getConfig());
    }

    public ConfigValue.Resolver getResolver(@Nullable RunConfigSettings runConfig) {
        return variable -> this.resolve(runConfig, variable);
    }

    private String resolve(@Nullable RunConfigSettings runConfig, ConfigValue.Variable variable) {
        String key = variable.name();
        Object string = "{" + key + "}";
        if (key.equals("runtime_classpath")) {
            string = this.runtimeClasspath().stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
        } else if (key.equals("minecraft_classpath")) {
            string = this.minecraftClasspath().stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
        } else if (key.equals("runtime_classpath_file")) {
            Path path = this.extension.getFiles().getProjectPersistentCache().toPath().resolve("forge_runtime_classpath.txt");
            try {
                Files.writeString(path, (CharSequence)this.runtimeClasspath().stream().map(File::getAbsolutePath).collect(Collectors.joining("\n")), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            string = path.toAbsolutePath().toString();
        } else if (key.equals("minecraft_classpath_file")) {
            Path path = this.extension.getFiles().getProjectPersistentCache().toPath().resolve("forge_minecraft_classpath.txt");
            try {
                Files.writeString(path, (CharSequence)this.minecraftClasspath().stream().map(File::getAbsolutePath).collect(Collectors.joining("\n")), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            string = path.toAbsolutePath().toString();
        } else if (key.equals("asset_index")) {
            string = this.extension.getMinecraftProvider().getVersionInfo().assetIndex().fabricId(this.extension.getMinecraftProvider().minecraftVersion());
        } else if (key.equals("assets_root")) {
            string = new File(this.extension.getFiles().getUserCache(), "assets").getAbsolutePath();
        } else if (key.equals("natives")) {
            string = this.extension.getFiles().getNativesDirectory(this.project).getAbsolutePath();
        } else if (key.equals("source_roots")) {
            SetMultimap modClasses = MultimapBuilder.hashKeys().linkedHashSetValues().build();
            NamedDomainObjectContainer<ModSettings> mods = this.extension.getMods();
            if (runConfig != null && !runConfig.getMods().isEmpty()) {
                mods = runConfig.getMods();
            }
            for (ModSettings mod : mods) {
                for (SourceSetReference modSourceSet : (List)mod.getModSourceSets().get()) {
                    File resourcesDir = modSourceSet.sourceSet().getOutput().getResourcesDir();
                    modClasses.put((Object)mod.getName(), (Object)resourcesDir.getAbsolutePath());
                }
                for (File file : SourceSetHelper.getClasspath(mod, this.project)) {
                    modClasses.put((Object)mod.getName(), (Object)file.getAbsolutePath());
                }
            }
            string = modClasses.entries().stream().map(entry -> (String)entry.getKey() + "%%" + (String)entry.getValue()).collect(Collectors.joining(File.pathSeparator));
        } else if (key.equals("mcp_mappings")) {
            string = "loom.stub";
        } else if (this.json.has(key)) {
            JsonElement element = this.json.get(key);
            string = element.isJsonArray() ? StreamSupport.stream(element.getAsJsonArray().spliterator(), false).map(JsonElement::getAsString).flatMap(str -> {
                if (str.contains(":")) {
                    return DependencyDownloader.download(this.project, str, false, false).getFiles().stream().map(File::getAbsolutePath).filter(dep -> !dep.contains("bootstraplauncher"));
                }
                return Stream.of(str);
            }).collect(Collectors.joining(File.pathSeparator)) : element.toString();
        } else {
            this.project.getLogger().warn("Unrecognized template! " + (String)string);
        }
        return string;
    }

    private Set<File> runtimeClasspath() {
        return this.minecraftClasspath();
    }

    private Set<File> minecraftClasspath() {
        return DependencyDownloader.resolveFiles(this.project, this.project.getConfigurations().getByName("forgeRuntimeLibrary"), true);
    }
}

