/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.loom.forge.UserdevConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.configuration.providers.forge.DependencyProvider;
import net.fabricmc.loom.util.ZipUtils;
import org.gradle.api.Project;

public class ForgeUserdevProvider
extends DependencyProvider {
    private File userdevJar;
    private JsonObject json;
    private UserdevConfig config;
    Path joinedPatches;

    public ForgeUserdevProvider(Project project) {
        super(project);
    }

    @Override
    public void provide(DependencyInfo dependency) throws Exception {
        this.userdevJar = new File(this.getExtension().getForgeProvider().getGlobalCache(), "forge-userdev.jar");
        this.joinedPatches = this.getExtension().getForgeProvider().getGlobalCache().toPath().resolve("patches-joined.lzma");
        Path configJson = this.getExtension().getForgeProvider().getGlobalCache().toPath().resolve("forge-config.json");
        if (!this.userdevJar.exists() || Files.notExists(configJson, new LinkOption[0]) || this.refreshDeps()) {
            File resolved = dependency.resolveFile().orElseThrow(() -> new RuntimeException("Could not resolve Forge userdev"));
            Files.copy(resolved.toPath(), this.userdevJar.toPath(), StandardCopyOption.REPLACE_EXISTING);
            Files.write(configJson, ZipUtils.unpack(resolved.toPath(), "config.json"), new OpenOption[0]);
        }
        try (BufferedReader reader = Files.newBufferedReader(configJson);){
            this.json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            this.config = (UserdevConfig)UserdevConfig.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)this.json).getOrThrow(false, msg -> this.getProject().getLogger().error("Couldn't read userdev config, {}", msg));
        }
        this.addDependency(this.config.mcp(), "mcp");
        if (!this.getExtension().isNeoForge()) {
            this.addDependency(this.config.mcp(), "srg");
        }
        this.addDependency(this.config.universal(), "forgeUniversal");
        if (Files.notExists(this.joinedPatches, new LinkOption[0])) {
            Files.write(this.joinedPatches, ZipUtils.unpack(this.userdevJar.toPath(), this.config.binpatches()), new OpenOption[0]);
        }
    }

    public File getUserdevJar() {
        return this.userdevJar;
    }

    @Override
    public String getTargetConfig() {
        return "forgeUserdev";
    }

    public JsonObject getJson() {
        return this.json;
    }

    public UserdevConfig getConfig() {
        return this.config;
    }
}

