/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge.mcpconfig;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.util.Map;
import net.fabricmc.loom.configuration.providers.forge.ConfigValue;

public record McpConfigStep(String type, String name, Map<String, ConfigValue> config) {
    private static final String TYPE_KEY = "type";
    private static final String NAME_KEY = "name";

    public static McpConfigStep fromJson(JsonObject json) {
        String type = json.get(TYPE_KEY).getAsString();
        String name = json.has(NAME_KEY) ? json.get(NAME_KEY).getAsString() : type;
        ImmutableMap.Builder config = ImmutableMap.builder();
        for (String key : json.keySet()) {
            if (key.equals(TYPE_KEY) || key.equals(NAME_KEY)) continue;
            config.put((Object)key, (Object)ConfigValue.of(json.get(key).getAsString()));
        }
        return new McpConfigStep(type, name, (Map<String, ConfigValue>)config.build());
    }
}

