/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic;

import java.io.IOException;
import java.nio.file.Path;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.McpConfigFunction;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.StepLogic;
import org.gradle.api.Action;
import org.gradle.process.JavaExecSpec;

public final class FunctionLogic
implements StepLogic {
    private final McpConfigFunction function;

    public FunctionLogic(McpConfigFunction function) {
        this.function = function;
    }

    @Override
    public void execute(StepLogic.ExecutionContext context) throws IOException {
        String mainClass;
        context.setOutput("output.jar");
        Path jar = this.function.download(context);
        try (JarFile jarFile = new JarFile(jar.toFile());){
            mainClass = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        }
        catch (IOException e) {
            throw new IOException("Could not determine main class for " + jar.toAbsolutePath(), e);
        }
        context.javaexec((Action<? super JavaExecSpec>)((Action)spec -> {
            spec.classpath(new Object[]{jar});
            spec.getMainClass().set((Object)mainClass);
            spec.args(context.resolve(this.function.args()));
            spec.jvmArgs(context.resolve(this.function.jvmArgs()));
        }));
    }

    @Override
    public String getDisplayName(String stepName) {
        return stepName + " with " + this.function.version();
    }
}

