/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.loom.configuration.providers.forge.ConfigValue;
import net.fabricmc.loom.util.download.DownloadBuilder;
import net.fabricmc.loom.util.function.CollectionUtil;
import org.gradle.api.Action;
import org.gradle.api.logging.Logger;
import org.gradle.process.JavaExecSpec;

public interface StepLogic {
    public void execute(ExecutionContext var1) throws IOException;

    default public String getDisplayName(String stepName) {
        return stepName;
    }

    default public boolean hasNoContext() {
        return false;
    }

    @FunctionalInterface
    public static interface Provider {
        public Optional<StepLogic> getStepLogic(String var1, String var2);
    }

    public static interface ExecutionContext {
        public Logger logger();

        public Path setOutput(String var1) throws IOException;

        public Path setOutput(Path var1);

        public Path cache() throws IOException;

        public Path mappings();

        public String resolve(ConfigValue var1);

        public Path downloadFile(String var1) throws IOException;

        public Path downloadDependency(String var1);

        public DownloadBuilder downloadBuilder(String var1);

        public void javaexec(Action<? super JavaExecSpec> var1);

        public Set<File> getMinecraftLibraries();

        default public List<String> resolve(List<ConfigValue> configValues) {
            return CollectionUtil.map(configValues, this::resolve);
        }
    }
}

