/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings;

import java.io.File;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingContext;
import net.fabricmc.loom.configuration.providers.mappings.IntermediateMappingsService;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.util.download.DownloadBuilder;
import net.fabricmc.loom.util.service.ScopedSharedServiceManager;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.logging.Logger;

public class GradleMappingContext
implements MappingContext {
    private final Project project;
    private final LoomGradleExtension extension;
    private final String workingDirName;

    public GradleMappingContext(Project project, String workingDirName) {
        this.project = project;
        this.extension = LoomGradleExtension.get(project);
        this.workingDirName = workingDirName;
    }

    @Override
    public Path resolveDependency(Dependency dependency) {
        Configuration configuration = this.project.getConfigurations().detachedConfiguration(new Dependency[]{dependency});
        configuration.resolutionStrategy(ResolutionStrategy::failOnNonReproducibleResolution);
        return configuration.getSingleFile().toPath();
    }

    @Override
    public Path resolveMavenDependency(String mavenNotation) {
        return this.resolveDependency(this.project.getDependencies().create((Object)mavenNotation));
    }

    @Override
    public Path resolveDependency(MinimalExternalModuleDependency dependency) {
        return this.resolveDependency(this.project.getDependencies().create((Object)dependency));
    }

    @Override
    public Supplier<MemoryMappingTree> intermediaryTree() {
        return () -> {
            try (ScopedSharedServiceManager serviceManager = new ScopedSharedServiceManager();){
                MemoryMappingTree memoryMappingTree = IntermediateMappingsService.getInstance(serviceManager, this.project, this.minecraftProvider()).getMemoryMappingTree();
                return memoryMappingTree;
            }
        };
    }

    @Override
    public MinecraftProvider minecraftProvider() {
        return this.extension.getMinecraftProvider();
    }

    @Override
    public Path workingDirectory(String name) {
        return new File(this.minecraftProvider().dir("layered/working_dir/" + this.workingDirName), name).toPath();
    }

    @Override
    public Logger getLogger() {
        return this.project.getLogger();
    }

    @Override
    public DownloadBuilder download(String url) {
        return this.extension.download(url);
    }

    @Override
    public boolean refreshDeps() {
        return this.extension.refreshDeps();
    }

    public Project getProject() {
        return this.project;
    }

    public LoomGradleExtension getExtension() {
        return this.extension;
    }
}

