/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings;

import com.google.common.base.Suppliers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.intermediate.IntermediateMappingsProvider;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.IntermediateMappingsProviderInternal;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.util.service.SharedService;
import net.fabricmc.loom.util.service.SharedServiceManager;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingNsCompleter;
import net.fabricmc.mappingio.format.tiny.Tiny2FileReader;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.Project;
import org.jetbrains.annotations.VisibleForTesting;

public final class IntermediateMappingsService
implements SharedService {
    private final Path intermediaryTiny;
    private final String expectedSrcNs;
    private final Supplier<MemoryMappingTree> memoryMappingTree = Suppliers.memoize(this::createMemoryMappingTree);

    private IntermediateMappingsService(Path intermediaryTiny, String expectedSrcNs) {
        this.intermediaryTiny = intermediaryTiny;
        this.expectedSrcNs = expectedSrcNs;
    }

    public static synchronized IntermediateMappingsService getInstance(SharedServiceManager sharedServiceManager, Project project, MinecraftProvider minecraftProvider) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        IntermediateMappingsProvider intermediateProvider = extension.getIntermediateMappingsProvider();
        String id = "IntermediateMappingsService:%s:%s".formatted(intermediateProvider.getName(), intermediateProvider.getMinecraftVersion().get());
        return sharedServiceManager.getOrCreateService(id, () -> IntermediateMappingsService.create(intermediateProvider, minecraftProvider, project));
    }

    @VisibleForTesting
    public static IntermediateMappingsService create(IntermediateMappingsProvider intermediateMappingsProvider, MinecraftProvider minecraftProvider, Project project) {
        Path intermediaryTiny = minecraftProvider.file(intermediateMappingsProvider.getName() + ".tiny").toPath();
        try {
            if (intermediateMappingsProvider instanceof IntermediateMappingsProviderInternal) {
                IntermediateMappingsProviderInternal internal = (IntermediateMappingsProviderInternal)intermediateMappingsProvider;
                internal.provide(intermediaryTiny, project);
            } else {
                intermediateMappingsProvider.provide(intermediaryTiny);
            }
        }
        catch (IOException e) {
            try {
                Files.deleteIfExists(intermediaryTiny);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            throw new UncheckedIOException("Failed to provide intermediate mappings", e);
        }
        String expectedSrcNs = minecraftProvider.isLegacyVersion() ? MappingsNamespace.INTERMEDIARY.toString() : MappingsNamespace.OFFICIAL.toString();
        return new IntermediateMappingsService(intermediaryTiny, expectedSrcNs);
    }

    private MemoryMappingTree createMemoryMappingTree() {
        MemoryMappingTree tree = new MemoryMappingTree();
        try {
            MappingNsCompleter nsCompleter = new MappingNsCompleter((MappingVisitor)tree, Collections.singletonMap(MappingsNamespace.NAMED.toString(), MappingsNamespace.INTERMEDIARY.toString()), true);
            try (BufferedReader reader = Files.newBufferedReader(this.getIntermediaryTiny(), StandardCharsets.UTF_8);){
                Tiny2FileReader.read((Reader)reader, (MappingVisitor)nsCompleter);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read intermediary mappings", e);
        }
        if (!this.expectedSrcNs.equals(tree.getSrcNamespace())) {
            throw new RuntimeException("Invalid intermediate mappings: expected source namespace '" + this.expectedSrcNs + "' but found '" + tree.getSrcNamespace() + "'");
        }
        return tree;
    }

    public MemoryMappingTree getMemoryMappingTree() {
        return this.memoryMappingTree.get();
    }

    public Path getIntermediaryTiny() {
        return Objects.requireNonNull(this.intermediaryTiny, "Intermediary mappings have not been setup");
    }
}

