/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonObject;
import dev.architectury.loom.util.MappingOption;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.configuration.providers.forge.ForgeMigratedMappingConfiguration;
import net.fabricmc.loom.configuration.providers.forge.SrgProvider;
import net.fabricmc.loom.configuration.providers.mappings.GradleMappingContext;
import net.fabricmc.loom.configuration.providers.mappings.IntermediateMappingsService;
import net.fabricmc.loom.configuration.providers.mappings.TinyMappingsService;
import net.fabricmc.loom.configuration.providers.mappings.tiny.MappingsMerger;
import net.fabricmc.loom.configuration.providers.mappings.tiny.TinyJarInfo;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.util.DeletingFileVisitor;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.ModPlatform;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.service.ScopedSharedServiceManager;
import net.fabricmc.loom.util.service.SharedServiceManager;
import net.fabricmc.loom.util.srg.ForgeMappingsMerger;
import net.fabricmc.loom.util.srg.MCPReader;
import net.fabricmc.loom.util.srg.SrgNamedWriter;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.format.tiny.Tiny2FileWriter;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.stitch.Command;
import net.fabricmc.stitch.commands.CommandProposeFieldNames;
import net.fabricmc.stitch.commands.tinyv2.TinyFile;
import net.fabricmc.stitch.commands.tinyv2.TinyV2Writer;
import org.apache.tools.ant.util.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Opcodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingConfiguration.class);
    public final String mappingsIdentifier;
    private final Path mappingsWorkingDir;
    private final Path baseTinyMappings;
    public Path tinyMappings;
    public final Path tinyMappingsJar;
    public Path tinyMappingsWithMojang;
    public Path tinyMappingsWithSrg;
    public final Map<String, Path> mixinTinyMappings;
    public final Path srgToNamedSrg;
    private final Path unpickDefinitions;
    private boolean hasUnpickDefinitions;
    private UnpickMetadata unpickMetadata;
    private Map<String, String> signatureFixes;

    protected MappingConfiguration(String mappingsIdentifier, Path mappingsWorkingDir) {
        this.mappingsIdentifier = mappingsIdentifier;
        this.mappingsWorkingDir = mappingsWorkingDir;
        this.baseTinyMappings = mappingsWorkingDir.resolve("mappings-base.tiny");
        this.tinyMappings = mappingsWorkingDir.resolve("mappings.tiny");
        this.tinyMappingsJar = mappingsWorkingDir.resolve("mappings.jar");
        this.unpickDefinitions = mappingsWorkingDir.resolve("mappings.unpick");
        this.tinyMappingsWithSrg = mappingsWorkingDir.resolve("mappings-srg.tiny");
        this.tinyMappingsWithMojang = mappingsWorkingDir.resolve("mappings-mojang.tiny");
        this.mixinTinyMappings = new HashMap<String, Path>();
        this.srgToNamedSrg = mappingsWorkingDir.resolve("mappings-srg-named.srg");
    }

    public static MappingConfiguration create(Project project, SharedServiceManager serviceManager, DependencyInfo dependency, MinecraftProvider minecraftProvider) {
        String version = dependency.getResolvedVersion();
        Path inputJar = dependency.resolveFile().orElseThrow(() -> new RuntimeException("Could not resolve mappings: " + dependency)).toPath();
        String mappingsName = StringUtils.removeSuffix((String)(dependency.getDependency().getGroup() + "." + dependency.getDependency().getName()), (String)"-unmerged");
        TinyJarInfo jarInfo = TinyJarInfo.get(inputJar);
        jarInfo.minecraftVersionId().ifPresent(id -> {
            if (!minecraftProvider.minecraftVersion().equals(id)) {
                LOGGER.warn("The mappings (%s) were not built for Minecraft version %s, proceed with caution.".formatted(dependency.getDepString(), minecraftProvider.minecraftVersion()));
            }
        });
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        Object mappingsIdentifier = extension.isForgeLike() ? MappingConfiguration.createForgeMappingsIdentifier(extension, mappingsName, version, MappingConfiguration.getMappingsClassifier(dependency, jarInfo.v2()), minecraftProvider.minecraftVersion()) : MappingConfiguration.createMappingsIdentifier(mappingsName, version, MappingConfiguration.getMappingsClassifier(dependency, jarInfo.v2()), minecraftProvider.minecraftVersion());
        if (extension.isQuilt()) {
            mappingsIdentifier = (String)mappingsIdentifier + "-arch-quilt";
        }
        Path workingDir = minecraftProvider.dir((String)mappingsIdentifier).toPath();
        MappingConfiguration mappingConfiguration = extension.isForgeLike() ? new ForgeMigratedMappingConfiguration((String)mappingsIdentifier, workingDir) : new MappingConfiguration((String)mappingsIdentifier, workingDir);
        try {
            mappingConfiguration.setup(project, serviceManager, minecraftProvider, inputJar);
        }
        catch (IOException e) {
            MappingConfiguration.cleanWorkingDirectory(workingDir);
            throw new UncheckedIOException("Failed to setup mappings: " + dependency.getDepString(), e);
        }
        return mappingConfiguration;
    }

    public TinyMappingsService getMappingsService(SharedServiceManager serviceManager) {
        return this.getMappingsService(serviceManager, MappingOption.DEFAULT);
    }

    public TinyMappingsService getMappingsService(SharedServiceManager serviceManager, MappingOption mappingOption) {
        Path tinyMappings = switch (mappingOption) {
            case MappingOption.WITH_SRG -> {
                if (Files.notExists(this.tinyMappingsWithSrg, new LinkOption[0])) {
                    throw new UnsupportedOperationException("Cannot get mappings service with SRG mappings without SRG enabled!");
                }
                yield this.tinyMappingsWithSrg;
            }
            case MappingOption.WITH_MOJANG -> {
                if (Files.notExists(this.tinyMappingsWithMojang, new LinkOption[0])) {
                    throw new UnsupportedOperationException("Cannot get mappings service with Mojang mappings without Mojang merging enabled!");
                }
                yield this.tinyMappingsWithMojang;
            }
            default -> this.tinyMappings;
        };
        return TinyMappingsService.create(serviceManager, Objects.requireNonNull(tinyMappings));
    }

    protected void setup(Project project, SharedServiceManager serviceManager, MinecraftProvider minecraftProvider, Path inputJar) throws IOException {
        if (minecraftProvider.refreshDeps()) {
            MappingConfiguration.cleanWorkingDirectory(this.mappingsWorkingDir);
        }
        if (Files.notExists(this.tinyMappings, new LinkOption[0]) || minecraftProvider.refreshDeps()) {
            this.storeMappings(project, serviceManager, minecraftProvider, inputJar);
        } else {
            try (FileSystemUtil.Delegate fileSystem = FileSystemUtil.getJarFileSystem(inputJar, false);){
                this.extractExtras(fileSystem.get());
            }
        }
        if (Files.notExists(this.tinyMappingsJar, new LinkOption[0]) || minecraftProvider.refreshDeps()) {
            Files.deleteIfExists(this.tinyMappingsJar);
            ZipUtils.add(this.tinyMappingsJar, "mappings/mappings.tiny", Files.readAllBytes(this.tinyMappings));
        }
    }

    public void setupPost(Project project) throws IOException {
        Tiny2FileWriter writer;
        Stopwatch stopwatch;
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        if (extension.isNeoForge() && (Files.notExists(this.tinyMappingsWithMojang, new LinkOption[0]) || extension.refreshDeps())) {
            stopwatch = Stopwatch.createStarted();
            GradleMappingContext context = new GradleMappingContext(project, "tmp-neoforge");
            writer = new Tiny2FileWriter((Writer)Files.newBufferedWriter(this.tinyMappingsWithMojang, new OpenOption[0]), false);
            try {
                ForgeMappingsMerger.mergeMojang(context, this.tinyMappings, null, true).accept((MappingVisitor)writer);
            }
            finally {
                writer.close();
            }
            project.getLogger().info(":merged mojang mappings in {}", (Object)stopwatch.stop());
        }
        if (extension.shouldGenerateSrgTiny() && (Files.notExists(this.tinyMappingsWithSrg, new LinkOption[0]) || extension.refreshDeps())) {
            stopwatch = Stopwatch.createStarted();
            ForgeMappingsMerger.ExtraMappings extraMappings = ForgeMappingsMerger.ExtraMappings.ofMojmapTsrg(MappingConfiguration.getMojmapSrgFileIfPossible(project));
            writer = new Tiny2FileWriter((Writer)Files.newBufferedWriter(this.tinyMappingsWithSrg, new OpenOption[0]), false);
            try {
                ForgeMappingsMerger.mergeSrg(MappingConfiguration.getRawSrgFile(project), this.tinyMappings, extraMappings, true).accept((MappingVisitor)writer);
            }
            finally {
                writer.close();
            }
            project.getLogger().info(":merged srg mappings in " + stopwatch.stop());
        }
        this.manipulateMappings(project, this.tinyMappingsJar);
    }

    public void applyToProject(Project project, DependencyInfo dependency) throws IOException {
        LoomGradleExtension extension;
        if (this.hasUnpickDefinitions()) {
            String notation = String.format("%s:%s:%s:constants", dependency.getDependency().getGroup(), dependency.getDependency().getName(), dependency.getDependency().getVersion());
            project.getDependencies().add("mappingsConstants", (Object)notation);
            this.populateUnpickClasspath(project);
        }
        if ((extension = LoomGradleExtension.get(project)).isForge()) {
            if (!extension.shouldGenerateSrgTiny()) {
                throw new IllegalStateException("We have to generate srg tiny in a forge environment!");
            }
            if (Files.notExists(this.srgToNamedSrg, new LinkOption[0]) || extension.refreshDeps()) {
                try (ScopedSharedServiceManager serviceManager = new ScopedSharedServiceManager();){
                    TinyMappingsService mappingsService = this.getMappingsService(serviceManager, MappingOption.WITH_SRG);
                    SrgNamedWriter.writeTo(project.getLogger(), this.srgToNamedSrg, (MappingTree)mappingsService.getMappingTree(), "srg", "named");
                }
            }
        }
        project.getDependencies().add("mappingsFinal", (Object)project.files(new Object[]{this.tinyMappingsJar.toFile()}));
    }

    public static Path getRawSrgFile(Project project) throws IOException {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        if (extension.getSrgProvider().isTsrgV2()) {
            return extension.getSrgProvider().getMergedMojangTrimmed();
        }
        return extension.getSrgProvider().getSrg();
    }

    public static Path getMojmapSrgFileIfPossible(Project project) {
        try {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            return SrgProvider.getMojmapTsrg2(project, extension);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void manipulateMappings(Project project, Path mappingsJar) throws IOException {
    }

    private static String getMappingsClassifier(DependencyInfo dependency, boolean isV2) {
        String[] depStringSplit = dependency.getDepString().split(":");
        if (depStringSplit.length >= 4) {
            return "-" + depStringSplit[3] + (isV2 ? "-v2" : "");
        }
        return isV2 ? "-v2" : "";
    }

    private void storeMappings(Project project, SharedServiceManager serviceManager, MinecraftProvider minecraftProvider, Path inputJar) throws IOException {
        LOGGER.info(":extracting " + inputJar.getFileName());
        if (this.isMCP(inputJar)) {
            try {
                this.readAndMergeMCP(project, serviceManager, minecraftProvider, inputJar);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
        try (FileSystemUtil.Delegate delegate = FileSystemUtil.getJarFileSystem(inputJar);){
            MappingConfiguration.extractMappings(delegate.fs(), this.baseTinyMappings);
            this.extractExtras(delegate.fs());
        }
        if (MappingConfiguration.areMappingsMergedV2(this.baseTinyMappings)) {
            Files.copy(this.baseTinyMappings, this.tinyMappings, StandardCopyOption.REPLACE_EXISTING);
        } else if (MappingConfiguration.areMappingsV2(this.baseTinyMappings)) {
            IntermediateMappingsService intermediateMappingsService = IntermediateMappingsService.getInstance(serviceManager, project, minecraftProvider);
            MappingsMerger.mergeAndSaveMappings(this.baseTinyMappings, this.tinyMappings, minecraftProvider, intermediateMappingsService);
        } else {
            if (LoomGradleExtension.get(project).isForgeLike()) {
                throw new UnsupportedOperationException("Forge cannot be used with V1 mappings!");
            }
            List<Path> minecraftJars = minecraftProvider.getMinecraftJars();
            if (minecraftJars.size() != 1) {
                throw new UnsupportedOperationException("V1 mappings only support single jar minecraft providers");
            }
            Files.deleteIfExists(this.tinyMappings);
            LOGGER.info(":populating field names");
            this.suggestFieldNames(minecraftJars.get(0), this.baseTinyMappings, this.tinyMappings);
        }
    }

    private void readAndMergeMCP(Project project, SharedServiceManager serviceManager, MinecraftProvider minecraftProvider, Path mcpJar) throws Exception {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        IntermediateMappingsService intermediateMappingsService = IntermediateMappingsService.getInstance(serviceManager, project, minecraftProvider);
        Path intermediaryTinyPath = intermediateMappingsService.getIntermediaryTiny();
        SrgProvider provider = extension.getSrgProvider();
        if (provider == null) {
            if (!extension.shouldGenerateSrgTiny()) {
                Configuration srg = (Configuration)project.getConfigurations().maybeCreate("srg");
                srg.setTransitive(false);
            }
            provider = new SrgProvider(project);
            project.getDependencies().add(provider.getTargetConfig(), (Object)("de.oceanlabs.mcp:mcp_config:" + extension.getMinecraftProvider().minecraftVersion()));
            Configuration configuration = project.getConfigurations().getByName(provider.getTargetConfig());
            provider.provide(DependencyInfo.create(project, (Dependency)configuration.getDependencies().iterator().next(), configuration));
        }
        Path srgPath = MappingConfiguration.getRawSrgFile(project);
        TinyFile file = new MCPReader(intermediaryTinyPath, srgPath).read(mcpJar);
        TinyV2Writer.write((TinyFile)file, (Path)this.tinyMappings);
    }

    private boolean isMCP(Path path) throws IOException {
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(path, false);){
            boolean bl = Files.exists(fs.getPath("fields.csv", new String[0]), new LinkOption[0]) && Files.exists(fs.getPath("methods.csv", new String[0]), new LinkOption[0]);
            return bl;
        }
    }

    private static boolean areMappingsV2(Path path) throws IOException {
        boolean bl;
        block8: {
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                boolean bl2 = bl = MappingReader.detectFormat((Reader)reader) == MappingFormat.TINY_2_FILE;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    return false;
                }
            }
            reader.close();
        }
        return bl;
    }

    private static boolean areMappingsMergedV2(Path path) throws IOException {
        boolean bl;
        block8: {
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                reader.mark(4096);
                boolean isTinyV2 = MappingReader.detectFormat((Reader)reader) == MappingFormat.TINY_2_FILE;
                reader.reset();
                boolean bl2 = bl = isTinyV2 && MappingReader.getNamespaces((Reader)reader, (MappingFormat)MappingFormat.TINY_2_FILE).containsAll(Arrays.asList("named", "intermediary", "official"));
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    return false;
                }
            }
            reader.close();
        }
        return bl;
    }

    public static void extractMappings(Path jar, Path extractTo) throws IOException {
        try (FileSystemUtil.Delegate delegate = FileSystemUtil.getJarFileSystem(jar);){
            MappingConfiguration.extractMappings(delegate.fs(), extractTo);
        }
    }

    public static void extractMappings(FileSystem jar, Path extractTo) throws IOException {
        Files.copy(jar.getPath("mappings/mappings.tiny", new String[0]), extractTo, StandardCopyOption.REPLACE_EXISTING);
    }

    private void extractExtras(FileSystem jar) throws IOException {
        this.extractUnpickDefinitions(jar);
        this.extractSignatureFixes(jar);
    }

    private void extractUnpickDefinitions(FileSystem jar) throws IOException {
        Path unpickPath = jar.getPath("extras/definitions.unpick", new String[0]);
        Path unpickMetadataPath = jar.getPath("extras/unpick.json", new String[0]);
        if (!Files.exists(unpickPath, new LinkOption[0]) || !Files.exists(unpickMetadataPath, new LinkOption[0])) {
            return;
        }
        Files.copy(unpickPath, this.unpickDefinitions, StandardCopyOption.REPLACE_EXISTING);
        this.unpickMetadata = this.parseUnpickMetadata(unpickMetadataPath);
        this.hasUnpickDefinitions = true;
    }

    private void extractSignatureFixes(FileSystem jar) throws IOException {
        Path recordSignaturesJsonPath = jar.getPath("extras/record_signatures.json", new String[0]);
        if (!Files.exists(recordSignaturesJsonPath, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(recordSignaturesJsonPath, StandardCharsets.UTF_8);){
            this.signatureFixes = (Map)LoomGradlePlugin.GSON.fromJson((Reader)reader, Map.class);
        }
    }

    private UnpickMetadata parseUnpickMetadata(Path input) throws IOException {
        JsonObject jsonObject = (JsonObject)LoomGradlePlugin.GSON.fromJson(Files.readString(input, StandardCharsets.UTF_8), JsonObject.class);
        if (!jsonObject.has("version") || jsonObject.get("version").getAsInt() != 1) {
            throw new UnsupportedOperationException("Unsupported unpick version");
        }
        return new UnpickMetadata(jsonObject.get("unpickGroup").getAsString(), jsonObject.get("unpickVersion").getAsString());
    }

    private void populateUnpickClasspath(Project project) {
        String[] asmDeps;
        String unpickCliName = "unpick-cli";
        project.getDependencies().add("unpick", (Object)String.format("%s:%s:%s", this.unpickMetadata.unpickGroup, unpickCliName, this.unpickMetadata.unpickVersion));
        for (String asm : asmDeps = new String[]{"org.ow2.asm:asm:%s", "org.ow2.asm:asm-tree:%s", "org.ow2.asm:asm-commons:%s", "org.ow2.asm:asm-util:%s"}) {
            project.getDependencies().add("unpick", (Object)asm.formatted(Opcodes.class.getPackage().getImplementationVersion()));
        }
    }

    private void suggestFieldNames(Path inputJar, Path oldMappings, Path newMappings) {
        CommandProposeFieldNames command = new CommandProposeFieldNames();
        this.runCommand((Command)command, inputJar.toFile().getAbsolutePath(), oldMappings.toAbsolutePath().toString(), newMappings.toAbsolutePath().toString());
    }

    private void runCommand(Command command, String ... args) {
        try {
            command.run(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void cleanWorkingDirectory(Path mappingsWorkingDir) {
        try {
            if (Files.exists(mappingsWorkingDir, new LinkOption[0])) {
                Files.walkFileTree(mappingsWorkingDir, new DeletingFileVisitor());
            }
            Files.createDirectories(mappingsWorkingDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Path mappingsWorkingDir() {
        return this.mappingsWorkingDir;
    }

    protected static String createMappingsIdentifier(String mappingsName, String version, String classifier, String minecraftVersion) {
        return mappingsName + "." + minecraftVersion.replace(' ', '_').replace('.', '_').replace('-', '_') + "." + version + classifier;
    }

    protected static String createForgeMappingsIdentifier(LoomGradleExtension extension, String mappingsName, String version, String classifier, String minecraftVersion) {
        String base = MappingConfiguration.createMappingsIdentifier(mappingsName, version, classifier, minecraftVersion);
        String platform = ((ModPlatform)((Object)extension.getPlatform().get())).id();
        String forgeVersion = extension.getForgeProvider().getVersion().getCombined();
        return base + "-" + platform + "-" + forgeVersion;
    }

    public String mappingsIdentifier() {
        return this.mappingsIdentifier;
    }

    public File getUnpickDefinitionsFile() {
        return this.unpickDefinitions.toFile();
    }

    public boolean hasUnpickDefinitions() {
        return this.hasUnpickDefinitions;
    }

    @Nullable
    public Map<String, String> getSignatureFixes() {
        return this.signatureFixes;
    }

    public String getBuildServiceName(String name, String from, String to) {
        return "%s:%s:%s>%S".formatted(name, this.mappingsIdentifier(), from, to);
    }

    public Path getReplacedTarget(LoomGradleExtension loom, String namespace) {
        if (namespace.equals("intermediary")) {
            return this.getPlatformMappingFile(loom);
        }
        return this.mixinTinyMappings.computeIfAbsent(namespace, k -> {
            Path path = this.mappingsWorkingDir.resolve("mappings-mixin-" + namespace + ".tiny");
            try {
                if (Files.notExists(path, new LinkOption[0]) || loom.refreshDeps()) {
                    ArrayList<String> lines = new ArrayList<String>(Files.readAllLines(this.getPlatformMappingFile(loom)));
                    lines.set(0, ((String)lines.get(0)).replace("intermediary", "yraidemretni").replace(namespace, "intermediary"));
                    Files.deleteIfExists(path);
                    Files.write(path, lines, new OpenOption[0]);
                }
                return path;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public Path getPlatformMappingFile(LoomGradleExtension extension) {
        if (extension.shouldGenerateSrgTiny()) {
            return this.tinyMappingsWithSrg;
        }
        if (extension.isNeoForge()) {
            return this.tinyMappingsWithMojang;
        }
        return this.tinyMappings;
    }

    public record UnpickMetadata(String unpickGroup, String unpickVersion) {
    }
}

