/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.library;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.fabricmc.loom.configuration.providers.minecraft.library.Library;
import net.fabricmc.loom.configuration.providers.minecraft.library.LibraryContext;
import net.fabricmc.loom.configuration.providers.minecraft.library.LibraryProcessor;
import net.fabricmc.loom.configuration.providers.minecraft.library.processors.ArmNativesLibraryProcessor;
import net.fabricmc.loom.configuration.providers.minecraft.library.processors.LWJGL2MavenLibraryProcessor;
import net.fabricmc.loom.configuration.providers.minecraft.library.processors.LWJGL3UpgradeLibraryProcessor;
import net.fabricmc.loom.configuration.providers.minecraft.library.processors.LegacyASMLibraryProcessor;
import net.fabricmc.loom.configuration.providers.minecraft.library.processors.LoomNativeSupportLibraryProcessor;
import net.fabricmc.loom.configuration.providers.minecraft.library.processors.ObjcBridgeUpgradeLibraryProcessor;
import net.fabricmc.loom.configuration.providers.minecraft.library.processors.RuntimeLog4jLibraryProcessor;
import net.fabricmc.loom.util.Platform;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.jetbrains.annotations.VisibleForTesting;

public class LibraryProcessorManager {
    public static final List<LibraryProcessorFactory> DEFAULT_LIBRARY_PROCESSORS = List.of(ArmNativesLibraryProcessor::new, LegacyASMLibraryProcessor::new, LoomNativeSupportLibraryProcessor::new, LWJGL2MavenLibraryProcessor::new, LWJGL3UpgradeLibraryProcessor::new, ObjcBridgeUpgradeLibraryProcessor::new, RuntimeLog4jLibraryProcessor::new);
    private final Platform platform;
    private final RepositoryHandler repositories;
    private final List<LibraryProcessorFactory> libraryProcessorFactories;
    private final List<String> enabledProcessors;

    public LibraryProcessorManager(Platform platform, RepositoryHandler repositories, List<LibraryProcessorFactory> libraryProcessorFactories, List<String> enabledProcessors) {
        this.platform = platform;
        this.repositories = repositories;
        this.libraryProcessorFactories = libraryProcessorFactories;
        this.enabledProcessors = enabledProcessors;
    }

    @VisibleForTesting
    public LibraryProcessorManager(Platform platform, RepositoryHandler repositories) {
        this(platform, repositories, DEFAULT_LIBRARY_PROCESSORS, Collections.emptyList());
    }

    private List<LibraryProcessor> getProcessors(LibraryContext context) {
        ArrayList<LibraryProcessor> processors = new ArrayList<LibraryProcessor>();
        for (LibraryProcessorFactory factory : this.libraryProcessorFactories) {
            LibraryProcessor processor = (LibraryProcessor)factory.apply(this.platform, context);
            LibraryProcessor.ApplicationResult applicationResult = processor.getApplicationResult();
            switch (applicationResult) {
                case MUST_APPLY: {
                    processors.add(processor);
                    break;
                }
                case CAN_APPLY: {
                    if (!this.enabledProcessors.contains(processor.getClass().getSimpleName())) break;
                    processors.add(processor);
                    break;
                }
            }
        }
        return Collections.unmodifiableList(processors);
    }

    public List<Library> processLibraries(List<Library> librariesIn, LibraryContext libraryContext) {
        List<LibraryProcessor> processors = this.getProcessors(libraryContext);
        if (processors.isEmpty()) {
            return librariesIn;
        }
        return this.processLibraries(processors, librariesIn);
    }

    @VisibleForTesting
    public List<Library> processLibraries(List<LibraryProcessor> processors, List<Library> librariesIn) {
        ArrayList<Library> libraries = new ArrayList<Library>(librariesIn);
        for (LibraryProcessor processor : processors) {
            ArrayList<Library> processedLibraries = new ArrayList<Library>();
            Predicate<Library> predicate = processor.apply(processedLibraries::add);
            for (Library library : libraries) {
                if (!predicate.test(library)) continue;
                processedLibraries.add(library);
            }
            processor.applyRepositories(this.repositories);
            libraries = processedLibraries;
        }
        return Collections.unmodifiableList(libraries);
    }

    public static interface LibraryProcessorFactory
    extends BiFunction<Platform, LibraryContext, LibraryProcessor> {
    }
}

