/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.mapped;

import dev.architectury.loom.util.MappingOption;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.build.IntermediaryNamespaces;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.mods.dependency.LocalMavenHelper;
import net.fabricmc.loom.configuration.providers.forge.minecraft.ForgeMinecraftProvider;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.configuration.providers.mappings.TinyMappingsService;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJar;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftSourceSets;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.configuration.providers.minecraft.SignatureFixerApplyVisitor;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.extension.LoomFiles;
import net.fabricmc.loom.util.SidedClassVisitor;
import net.fabricmc.loom.util.TinyRemapperHelper;
import net.fabricmc.loom.util.service.ScopedSharedServiceManager;
import net.fabricmc.loom.util.srg.InnerClassRemapper;
import net.fabricmc.loom.util.srg.RemapObjectHolderVisitor;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.gradle.api.Project;

public abstract class AbstractMappedMinecraftProvider<M extends MinecraftProvider>
implements MappedMinecraftProvider.ProviderImpl {
    protected final M minecraftProvider;
    private final Project project;
    protected final LoomGradleExtension extension;

    public AbstractMappedMinecraftProvider(Project project, M minecraftProvider) {
        this.minecraftProvider = minecraftProvider;
        this.project = project;
        this.extension = LoomGradleExtension.get(project);
    }

    public abstract MappingsNamespace getTargetNamespace();

    public abstract List<RemappedJars> getRemappedJars();

    public List<MinecraftJar.Type> getDependencyTypes() {
        return Collections.emptyList();
    }

    public List<MinecraftJar> provide(ProvideContext context) throws Exception {
        List<MinecraftJar.Type> dependencyTargets;
        List<RemappedJars> remappedJars = this.getRemappedJars();
        assert (!remappedJars.isEmpty());
        if (!this.areOutputsValid(remappedJars) || context.refreshOutputs()) {
            try {
                this.remapInputs(remappedJars, context.configContext());
            }
            catch (Throwable t) {
                this.cleanOutputs(remappedJars);
                throw new RuntimeException("Failed to remap minecraft", t);
            }
        }
        if (context.applyDependencies() && !(dependencyTargets = this.getDependencyTypes()).isEmpty()) {
            MinecraftSourceSets.get(this.getProject()).applyDependencies((configuration, type) -> this.getProject().getDependencies().add(configuration, (Object)this.getDependencyNotation((MinecraftJar.Type)((Object)type))), dependencyTargets);
        }
        return remappedJars.stream().map(RemappedJars::outputJar).toList();
    }

    @Override
    public Path getJar(MinecraftJar.Type type) {
        return this.getMavenHelper(type).getOutputFile(null);
    }

    public abstract MavenScope getMavenScope();

    public LocalMavenHelper getMavenHelper(MinecraftJar.Type type) {
        return new LocalMavenHelper("net.minecraft", this.getName(type), this.getVersion(), null, this.getMavenScope().getRoot(this.extension));
    }

    protected String getName(MinecraftJar.Type type) {
        String intermediateName = this.extension.getIntermediateMappingsProvider().getName();
        StringJoiner sj = new StringJoiner("-");
        sj.add("minecraft");
        sj.add(type.toString());
        if (!intermediateName.equals("intermediary-v2")) {
            sj.add(intermediateName);
        }
        if (this.getTargetNamespace() != MappingsNamespace.NAMED) {
            sj.add(this.getTargetNamespace().name());
        }
        return ((MinecraftProvider)this.minecraftProvider).getJarPrefix() + sj.toString().toLowerCase(Locale.ROOT);
    }

    protected String getVersion() {
        return "%s-%s".formatted(this.extension.getMinecraftProvider().minecraftVersion(), this.extension.getMappingConfiguration().mappingsIdentifier());
    }

    protected String getDependencyNotation(MinecraftJar.Type type) {
        return "net.minecraft:%s:%s".formatted(this.getName(type), this.getVersion());
    }

    private boolean areOutputsValid(List<RemappedJars> remappedJars) {
        ForgeMinecraftProvider withForge;
        for (RemappedJars remappedJar : remappedJars) {
            if (this.getMavenHelper(remappedJar.type()).exists(null)) continue;
            return false;
        }
        M m = this.minecraftProvider;
        return !(m instanceof ForgeMinecraftProvider) || !(withForge = (ForgeMinecraftProvider)m).getPatchedProvider().isDirty();
    }

    private void remapInputs(List<RemappedJars> remappedJars, ConfigContext configContext) throws IOException {
        this.cleanOutputs(remappedJars);
        for (RemappedJars remappedJar : remappedJars) {
            this.remapJar(remappedJar, configContext);
        }
    }

    private void remapJar(RemappedJars remappedJars, ConfigContext configContext) throws IOException {
        MappingConfiguration mappingConfiguration = this.extension.getMappingConfiguration();
        String fromM = remappedJars.sourceNamespace().toString();
        String toM = this.getTargetNamespace().toString();
        Files.deleteIfExists(remappedJars.outputJarPath());
        Set<String> classNames = this.extension.isForgeLike() ? InnerClassRemapper.readClassNames(remappedJars.inputJar()) : Set.of();
        Map<String, String> remappedSignatures = SignatureFixerApplyVisitor.getRemappedSignatures(this.getTargetNamespace() == MappingsNamespace.INTERMEDIARY, mappingConfiguration, this.getProject(), configContext.serviceManager(), toM);
        MinecraftVersionMeta.JavaVersion javaVersion = ((MinecraftProvider)this.minecraftProvider).getVersionInfo().javaVersion();
        boolean fixRecords = javaVersion != null && javaVersion.majorVersion() >= 16;
        TinyRemapper remapper = TinyRemapperHelper.getTinyRemapper(this.getProject(), configContext.serviceManager(), fromM, toM, fixRecords, builder -> {
            builder.extraPostApplyVisitor((TinyRemapper.ApplyVisitorProvider)new SignatureFixerApplyVisitor(remappedSignatures));
            this.configureRemapper(remappedJars, (TinyRemapper.Builder)builder);
        }, classNames);
        try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(remappedJars.outputJarPath()).build();){
            outputConsumer.addNonClassFiles(remappedJars.inputJar());
            for (Path path : remappedJars.remapClasspath()) {
                remapper.readClassPath(new Path[]{path});
            }
            remapper.readInputs(new Path[]{remappedJars.inputJar()});
            remapper.apply((BiConsumer)outputConsumer);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to remap JAR " + remappedJars.inputJar() + " with mappings from " + mappingConfiguration.tinyMappings, e);
        }
        finally {
            remapper.finish();
        }
        this.getMavenHelper(remappedJars.type()).savePom();
        if (this.extension.isForgeLikeAndOfficial()) {
            try (ScopedSharedServiceManager serviceManager = new ScopedSharedServiceManager();){
                MappingOption mappingOption = MappingOption.forPlatform(this.extension);
                TinyMappingsService mappingsService = this.extension.getMappingConfiguration().getMappingsService(serviceManager, mappingOption);
                String className = this.extension.isNeoForge() ? "net.neoforged.neoforge.registries.ObjectHolderRegistry" : "net.minecraftforge.registries.ObjectHolderRegistry";
                String sourceNamespace = IntermediaryNamespaces.intermediary(this.project);
                MemoryMappingTree mappings = mappingsService.getMappingTree();
                RemapObjectHolderVisitor.remapObjectHolder(remappedJars.outputJar().getPath(), className, (MappingTree)mappings, sourceNamespace, "named");
            }
        }
    }

    protected void configureRemapper(RemappedJars remappedJars, TinyRemapper.Builder tinyRemapperBuilder) {
    }

    public static void configureSplitRemapper(RemappedJars remappedJars, TinyRemapper.Builder tinyRemapperBuilder) {
        MinecraftJar outputJar = remappedJars.outputJar();
        assert (!outputJar.isMerged());
        if (outputJar.includesClient()) {
            assert (!outputJar.includesServer());
            tinyRemapperBuilder.extraPostApplyVisitor(SidedClassVisitor.CLIENT);
        }
    }

    private void cleanOutputs(List<RemappedJars> remappedJars) throws IOException {
        for (RemappedJars remappedJar : remappedJars) {
            Files.deleteIfExists(remappedJar.outputJarPath());
        }
    }

    public Project getProject() {
        return this.project;
    }

    public M getMinecraftProvider() {
        return this.minecraftProvider;
    }

    public record ProvideContext(boolean applyDependencies, boolean refreshOutputs, ConfigContext configContext) {
        ProvideContext withApplyDependencies(boolean applyDependencies) {
            return new ProvideContext(applyDependencies, this.refreshOutputs(), this.configContext());
        }
    }

    public static enum MavenScope {
        LOCAL(LoomFiles::getLocalMinecraftRepo),
        GLOBAL(LoomFiles::getGlobalMinecraftRepo);

        private final Function<LoomFiles, File> fileFunction;

        private MavenScope(Function<LoomFiles, File> fileFunction) {
            this.fileFunction = fileFunction;
        }

        public Path getRoot(LoomGradleExtension extension) {
            return this.fileFunction.apply(extension.getFiles()).toPath();
        }
    }

    public record RemappedJars(Path inputJar, MinecraftJar outputJar, MappingsNamespace sourceNamespace, Path[] remapClasspath) {
        public Path outputJarPath() {
            return this.outputJar().getPath();
        }

        public String name() {
            return this.outputJar().getName();
        }

        public MinecraftJar.Type type() {
            return this.outputJar().getType();
        }
    }
}

