/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.tr;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiConsumer;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.ThreadingUtils;
import net.fabricmc.tinyremapper.InputTag;
import net.fabricmc.tinyremapper.TinyRemapper;

public class OutputRemappingHandler {
    public static void remap(TinyRemapper remapper, Path assets, Path output) throws IOException {
        OutputRemappingHandler.remap(remapper, assets, output, null);
    }

    public static void remap(TinyRemapper remapper, Path assets, Path output, BiConsumer<String, byte[]> then) throws IOException {
        OutputRemappingHandler.remap(remapper, assets, output, then, null);
    }

    public static void remap(TinyRemapper remapper, Path assets, Path output, BiConsumer<String, byte[]> then, InputTag ... inputTags) throws IOException {
        Files.copy(assets, output, StandardCopyOption.REPLACE_EXISTING);
        try (FileSystemUtil.Delegate system = FileSystemUtil.getJarFileSystem(output, true);){
            ThreadingUtils.TaskCompleter taskCompleter = ThreadingUtils.taskCompleter();
            remapper.apply((path, bytes) -> {
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                try {
                    Path fsPath = system.get().getPath(path + ".class", new String[0]);
                    if (fsPath.getParent() != null) {
                        Files.createDirectories(fsPath.getParent(), new FileAttribute[0]);
                    }
                    taskCompleter.add(() -> Files.write(fsPath, bytes, StandardOpenOption.CREATE));
                    if (then != null) {
                        then.accept((String)path, (byte[])bytes);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }, inputTags);
            taskCompleter.complete();
        }
    }
}

