/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers.cache;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.StringJoiner;
import net.fabricmc.loom.util.Checksum;

public record ClassEntry(String parentClass, List<String> innerClasses) {
    public void copyTo(Path sourceRoot, Path targetRoot) throws IOException {
        Path targetPath = targetRoot.resolve(this.parentClass);
        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        Files.copy(sourceRoot.resolve(this.parentClass), targetPath, new CopyOption[0]);
        for (String innerClass : this.innerClasses) {
            Files.copy(sourceRoot.resolve(innerClass), targetRoot.resolve(innerClass), new CopyOption[0]);
        }
    }

    public String hash(Path root) throws IOException {
        StringJoiner joiner = new StringJoiner(",");
        joiner.add(Checksum.sha256Hex(Files.readAllBytes(root.resolve(this.parentClass))));
        for (String innerClass : this.innerClasses) {
            joiner.add(Checksum.sha256Hex(Files.readAllBytes(root.resolve(innerClass))));
        }
        return Checksum.sha256Hex(joiner.toString().getBytes());
    }

    public String sourcesFileName() {
        return this.parentClass.replace(".class", ".java");
    }
}

