/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ide.RunConfig;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.task.AbstractLoomTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GenIdeaProjectTask
extends AbstractLoomTask {
    @TaskAction
    public void genIdeaRuns() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        Project project = this.getProject();
        LoomGradleExtension extension = this.getExtension();
        if (!extension.isRootProject()) {
            return;
        }
        project.getLogger().lifecycle(":Building idea workspace");
        File file = project.file((Object)(project.getName() + ".iws"));
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(file);
        NodeList list = doc.getElementsByTagName("component");
        Element runManager = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Element element = (Element)list.item(i);
            if (!element.getAttribute("name").equals("RunManager")) continue;
            runManager = element;
            break;
        }
        if (runManager == null) {
            throw new RuntimeException("Failed to generate IntelliJ run configurations (runManager was not found)");
        }
        for (RunConfigSettings settings : this.getExtension().getRunConfigs()) {
            if (!settings.isIdeConfigGenerated()) continue;
            runManager.appendChild(RunConfig.runConfig(project, settings).genRuns(runManager));
            settings.makeRunDir();
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(source, result);
    }
}

