/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.configuration.ide.RunConfig;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.util.gradle.SyncTaskBuildService;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.TaskAction;

public abstract class GenVsCodeProjectTask
extends AbstractLoomTask {
    @ServiceReference(value="loomSyncTask")
    abstract Property<SyncTaskBuildService> getSyncTask();

    @TaskAction
    public void genRuns() throws IOException {
        GenVsCodeProjectTask.clean(this.getProject());
        GenVsCodeProjectTask.generate(this.getProject());
    }

    public static void clean(Project project) throws IOException {
        Path projectDir = project.getRootDir().toPath().resolve(".vscode");
        if (Files.notExists(projectDir, new LinkOption[0])) {
            Files.createDirectories(projectDir, new FileAttribute[0]);
        }
        Path launchJson = projectDir.resolve("launch.json");
        Files.deleteIfExists(launchJson);
    }

    public static void generate(Project project) throws IOException {
        VsCodeTasks tasks;
        JsonArray configurations;
        JsonObject root;
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        Path projectDir = project.getRootDir().toPath().resolve(".vscode");
        if (Files.notExists(projectDir, new LinkOption[0])) {
            Files.createDirectories(projectDir, new FileAttribute[0]);
        }
        Path launchJson = projectDir.resolve("launch.json");
        Path tasksJson = projectDir.resolve("tasks.json");
        if (Files.exists(launchJson, new LinkOption[0])) {
            root = (JsonObject)LoomGradlePlugin.GSON.fromJson(Files.readString(launchJson, StandardCharsets.UTF_8), JsonObject.class);
        } else {
            root = new JsonObject();
            root.addProperty("version", "0.2.0");
        }
        if (root.has("configurations")) {
            configurations = root.getAsJsonArray("configurations");
        } else {
            configurations = new JsonArray();
            root.add("configurations", (JsonElement)configurations);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        ArrayList<VsCodeConfiguration> configurationObjects = new ArrayList<VsCodeConfiguration>();
        for (RunConfigSettings settings : extension.getRunConfigs()) {
            if (!settings.isIdeConfigGenerated()) continue;
            RunConfig runConfig = RunConfig.runConfig(project, settings);
            VsCodeConfiguration configuration = new VsCodeConfiguration(project, runConfig);
            if (!configuration.tasksBeforeRun.isEmpty()) {
                configuration.preLaunchTask = "generated_" + runConfig.configName;
            }
            configurationObjects.add(configuration);
            JsonElement configurationJson = LoomGradlePlugin.GSON.toJsonTree((Object)configuration);
            LinkedList<JsonElement> toRemove = new LinkedList<JsonElement>();
            for (JsonElement jsonElement : configurations) {
                JsonObject jsonObject;
                if (!jsonElement.isJsonObject() || !(jsonObject = jsonElement.getAsJsonObject()).has("name") || !jsonObject.get("name").getAsString().equalsIgnoreCase(configuration.name)) continue;
                toRemove.add(jsonElement);
            }
            toRemove.forEach(arg_0 -> ((JsonArray)configurations).remove(arg_0));
            configurations.add(configurationJson);
            settings.makeRunDir();
        }
        String json = LoomGradlePlugin.GSON.toJson((JsonElement)root);
        Files.writeString(launchJson, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
        if (Files.exists(tasksJson, new LinkOption[0])) {
            try {
                tasks = (VsCodeTasks)gson.fromJson(Files.readString(tasksJson, StandardCharsets.UTF_8), VsCodeTasks.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read launch.json", e);
            }
        } else {
            tasks = new VsCodeTasks();
        }
        for (VsCodeConfiguration configuration : configurationObjects) {
            if (configuration.preLaunchTask == null || configuration.tasksBeforeRun == null) continue;
            String prefix = Os.isFamily((String)"windows") ? "gradlew.bat" : "./gradlew";
            tasks.add(new VsCodeTask(configuration.preLaunchTask, prefix + " " + configuration.tasksBeforeRun.stream().map(s -> {
                int i = s.indexOf(47);
                return i == -1 ? s : s.substring(i + 1);
            }).collect(Collectors.joining(" ")), "shell", new String[0]));
        }
        if (!tasks.tasks.isEmpty()) {
            String jsonTasks = gson.toJson((Object)tasks);
            try {
                Files.writeString(tasksJson, (CharSequence)jsonTasks, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write tasks.json", e);
            }
        }
    }

    private static class VsCodeConfiguration {
        public transient Project project;
        public String type = "java";
        public String name;
        public String request = "launch";
        public String cwd;
        public String console = "integratedTerminal";
        public boolean stopOnEntry = false;
        public String mainClass;
        public String vmArgs;
        public String args;
        public Map<String, Object> env;
        public String projectName;
        public transient List<String> tasksBeforeRun = new ArrayList<String>();
        public String preLaunchTask = null;

        VsCodeConfiguration(Project project, RunConfig runConfig) {
            this.name = runConfig.configName;
            this.mainClass = runConfig.mainClass;
            this.vmArgs = RunConfig.joinArguments(runConfig.vmArgs);
            this.args = RunConfig.joinArguments(runConfig.programArgs);
            this.cwd = "${workspaceFolder}/" + runConfig.runDir;
            this.env = new HashMap<String, Object>(runConfig.environmentVariables);
            this.projectName = runConfig.projectName;
            this.tasksBeforeRun.addAll(runConfig.vscodeBeforeRun);
            if (project.getRootProject() != project) {
                Path rootPath = project.getRootDir().toPath();
                Path projectPath = project.getProjectDir().toPath();
                String relativePath = rootPath.relativize(projectPath).toString();
                this.cwd = "${workspaceFolder}/%s/%s".formatted(relativePath, runConfig.runDir);
            }
        }
    }

    private static class VsCodeTasks {
        public String version = "2.0.0";
        public List<VsCodeTask> tasks = new ArrayList<VsCodeTask>();

        private VsCodeTasks() {
        }

        public void add(VsCodeTask vsCodeTask) {
            if (this.tasks.stream().noneMatch(task -> Objects.equals(task.label, vsCodeTask.label))) {
                this.tasks.add(vsCodeTask);
            }
        }
    }

    private static class VsCodeTask {
        public String label;
        public String command;
        public String type;
        public String[] args;
        public String group = "build";

        VsCodeTask(String label, String command, String type, String[] args) {
            this.label = label;
            this.command = command;
            this.type = type;
            this.args = args;
        }
    }
}

