/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.launch;

import dev.architectury.loom.util.ForgeLoggerConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.loom.task.AbstractLoomTask;
import org.gradle.api.tasks.TaskAction;

public abstract class GenerateLog4jConfigTask
extends AbstractLoomTask {
    @TaskAction
    public void run() {
        Path outputFile = this.getExtension().getFiles().getDefaultLog4jConfigFile().toPath();
        if (this.getExtension().isForge() && ((Boolean)this.getExtension().getForge().getUseForgeLoggerConfig().get()).booleanValue()) {
            ForgeLoggerConfig.copyToPath(this.getProject(), outputFile);
            return;
        }
        try (InputStream is = GenerateLog4jConfigTask.class.getClassLoader().getResourceAsStream("log4j2.fabric.xml");){
            Files.deleteIfExists(outputFile);
            Files.copy(is, outputFile, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate log4j config", e);
        }
    }
}

