/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.configuration.InstallerData;
import net.fabricmc.loom.util.LoomVersions;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.util.GradleVersion;

public abstract class JarManifestService
implements BuildService<Params> {
    public static synchronized Provider<JarManifestService> get(Project project) {
        return project.getGradle().getSharedServices().registerIfAbsent("LoomJarManifestService:" + project.getName(), JarManifestService.class, spec -> spec.parameters(params -> {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            Optional<String> tinyRemapperVersion = Optional.ofNullable(TinyRemapper.class.getPackage().getImplementationVersion());
            params.getGradleVersion().set((Object)GradleVersion.current().getVersion());
            params.getLoomVersion().set((Object)LoomGradlePlugin.LOOM_VERSION);
            params.getMCEVersion().set((Object)LoomVersions.MIXIN_COMPILE_EXTENSIONS.version());
            params.getMinecraftVersion().set(project.provider(() -> extension.getMinecraftProvider().minecraftVersion()));
            params.getTinyRemapperVersion().set((Object)tinyRemapperVersion.orElse("unknown"));
            params.getFabricLoaderVersion().set(project.provider(() -> Optional.ofNullable(extension.getInstallerData()).map(InstallerData::version).orElse("unknown")));
            params.getMixinVersion().set(JarManifestService.getMixinVersion(project));
        }));
    }

    public void apply(Manifest manifest, Map<String, String> extraValues) {
        Attributes attributes = manifest.getMainAttributes();
        extraValues.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> attributes.putValue((String)entry.getKey(), (String)entry.getValue()));
        if (Boolean.getBoolean("loom.test.reproducible")) {
            return;
        }
        Params p = (Params)this.getParameters();
        attributes.putValue("Fabric-Gradle-Version", (String)p.getGradleVersion().get());
        attributes.putValue("Fabric-Loom-Version", (String)p.getLoomVersion().get());
        attributes.putValue("Fabric-Mixin-Compile-Extensions-Version", (String)p.getMCEVersion().get());
        attributes.putValue("Fabric-Minecraft-Version", (String)p.getMinecraftVersion().get());
        attributes.putValue("Fabric-Tiny-Remapper-Version", (String)p.getTinyRemapperVersion().get());
        attributes.putValue("Fabric-Loader-Version", (String)p.getFabricLoaderVersion().get());
        if (!attributes.containsKey("Fabric-Mixin-Version")) {
            attributes.putValue("Fabric-Mixin-Version", ((MixinVersion)p.getMixinVersion().get()).version());
            attributes.putValue("Fabric-Mixin-Group", ((MixinVersion)p.getMixinVersion().get()).group());
        }
    }

    private static Provider<MixinVersion> getMixinVersion(Project project) {
        return project.getConfigurations().named("loaderLibraries").map(configuration -> {
            if (LoomGradleExtension.get(project).isForgeLike()) {
                return new MixinVersion("unknown", "unknown");
            }
            Optional<Dependency> dependency = configuration.getDependencies().stream().filter(dep -> "sponge-mixin".equals(dep.getName())).findFirst();
            if (dependency.isEmpty()) {
                project.getLogger().warn("Could not determine Mixin version for jar manifest");
            }
            return dependency.map(d -> new MixinVersion(d.getGroup(), d.getVersion())).orElse(new MixinVersion("unknown", "unknown"));
        });
    }

    static interface Params
    extends BuildServiceParameters {
        public Property<String> getGradleVersion();

        public Property<String> getLoomVersion();

        public Property<String> getMCEVersion();

        public Property<String> getMinecraftVersion();

        public Property<String> getTinyRemapperVersion();

        public Property<String> getFabricLoaderVersion();

        public Property<MixinVersion> getMixinVersion();
    }

    private record MixinVersion(String group, String version) implements Serializable
    {
    }
}

