/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.util.TinyRemapperHelper;
import net.fabricmc.loom.util.service.SharedService;
import net.fabricmc.loom.util.service.SharedServiceManager;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.tinyremapper.IMappingProvider;
import org.gradle.api.Project;

public final class MappingsService
implements SharedService {
    private final Options options;
    private IMappingProvider mappingProvider = null;
    private MemoryMappingTree memoryMappingTree = null;

    public static synchronized MappingsService create(SharedServiceManager sharedServiceManager, String name, Path mappingsFile, String from, String to, boolean remapLocals) {
        Options options = new Options(mappingsFile, from, to, remapLocals);
        String id = name + options.hashCode();
        return sharedServiceManager.getOrCreateService(id, () -> new MappingsService(options));
    }

    public static MappingsService createDefault(Project project, SharedServiceManager serviceManager, String from, String to) {
        MappingConfiguration mappingConfiguration = LoomGradleExtension.get(project).getMappingConfiguration();
        String name = mappingConfiguration.getBuildServiceName("mappingsProvider", from, to);
        return MappingsService.create(serviceManager, name, LoomGradleExtension.get(project).getPlatformMappingFile(), from, to, false);
    }

    public MappingsService(Options options) {
        this.options = options;
    }

    public synchronized IMappingProvider getMappingsProvider() {
        if (this.mappingProvider == null) {
            try {
                this.mappingProvider = TinyRemapperHelper.create(this.options.mappingsFile(), this.options.from(), this.options.to(), this.options.remapLocals());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read mappings from: " + this.options.mappingsFile(), e);
            }
        }
        return this.mappingProvider;
    }

    public synchronized MemoryMappingTree getMemoryMappingTree() {
        if (this.memoryMappingTree == null) {
            this.memoryMappingTree = new MemoryMappingTree();
            try {
                MappingReader.read((Path)this.options.mappingsFile(), (MappingVisitor)this.memoryMappingTree);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read mappings from: " + this.options.mappingsFile(), e);
            }
        }
        return this.memoryMappingTree;
    }

    public String getFromNamespace() {
        return this.options.from();
    }

    public String getToNamespace() {
        return this.options.to();
    }

    @Override
    public void close() {
        this.mappingProvider = null;
    }

    private record Options(Path mappingsFile, String from, String to, boolean remapLocals) {
    }
}

