/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.io.OutputStream;
import javax.inject.Inject;
import org.apache.commons.io.output.NullOutputStream;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.jetbrains.annotations.Nullable;

public abstract class ForgeToolExecutor {
    @Inject
    protected abstract JavaToolchainService getToolchainService();

    @Inject
    protected abstract Project getProject();

    public static boolean shouldShowVerboseStdout(Project project) {
        return project.getGradle().getStartParameter().getLogLevel().compareTo((Enum)LogLevel.LIFECYCLE) < 0;
    }

    public static boolean shouldShowVerboseStderr(Project project) {
        return ForgeToolExecutor.shouldShowVerboseStdout(project) || project.getGradle().getStartParameter().getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS;
    }

    public static ExecResult exec(Project project, Action<? super JavaExecSpec> configurator) {
        return ((ForgeToolExecutor)project.getObjects().newInstance(ForgeToolExecutor.class, new Object[0])).exec(configurator);
    }

    private ExecResult exec(Action<? super JavaExecSpec> configurator) {
        Project project = this.getProject();
        return project.javaexec(spec -> {
            configurator.execute(spec);
            if (ForgeToolExecutor.shouldShowVerboseStdout(project)) {
                spec.setStandardOutput((OutputStream)System.out);
            } else {
                spec.setStandardOutput((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
            }
            if (ForgeToolExecutor.shouldShowVerboseStderr(project)) {
                spec.setErrorOutput((OutputStream)System.err);
            } else {
                spec.setErrorOutput((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
            }
            @Nullable String executable = this.findJavaToolchainExecutable(project);
            if (executable != null) {
                spec.setExecutable(executable);
            }
        });
    }

    @Nullable
    private String findJavaToolchainExecutable(Project project) {
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        JavaToolchainSpec toolchain = java.getToolchain();
        if (!toolchain.getLanguageVersion().isPresent()) {
            return null;
        }
        JavaLauncher launcher = (JavaLauncher)this.getToolchainService().launcherFor(toolchain).get();
        return launcher.getExecutablePath().getAsFile().getAbsolutePath();
    }
}

