/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.RegularAsFlatMappingVisitor;
import net.fabricmc.mappingio.format.tiny.Tiny2FileWriter;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.TinyRemapper;

public class MappingsProviderVerbose {
    public static void saveFile(TinyRemapper providers) throws IOException {
        try {
            Field field = TinyRemapper.class.getDeclaredField("mappingProviders");
            field.setAccessible(true);
            Set mappingProviders = (Set)field.get(providers);
            MappingsProviderVerbose.saveFile(mappingProviders);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static void saveFile(Iterable<IMappingProvider> providers) throws IOException {
        MemoryMappingTree tree = new MemoryMappingTree();
        tree.setSrcNamespace("from");
        tree.setDstNamespaces(new ArrayList<String>(Collections.singletonList("to")));
        final RegularAsFlatMappingVisitor flatVisitor = new RegularAsFlatMappingVisitor((MappingVisitor)tree);
        for (IMappingProvider provider : providers) {
            provider.load(new IMappingProvider.MappingAcceptor(){

                public void acceptClass(String from, String to) {
                    try {
                        flatVisitor.visitClass(from, to);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }

                public void acceptMethod(IMappingProvider.Member from, String to) {
                    try {
                        flatVisitor.visitMethod(from.owner, from.name, from.desc, to);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }

                public void acceptMethodArg(IMappingProvider.Member from, int lvIndex, String to) {
                    try {
                        flatVisitor.visitMethodArg(from.owner, from.name, from.desc, lvIndex, lvIndex, "", to);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }

                public void acceptMethodVar(IMappingProvider.Member from, int i, int i1, int i2, String s) {
                }

                public void acceptField(IMappingProvider.Member from, String to) {
                    try {
                        flatVisitor.visitField(from.owner, from.name, from.desc, to);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
        }
        Path check = Files.createTempFile("CHECK", null, new FileAttribute[0]);
        StringWriter stringWriter = new StringWriter();
        Tiny2FileWriter tiny2Writer = new Tiny2FileWriter((Writer)stringWriter, false);
        tree.accept((MappingVisitor)tiny2Writer);
        Files.writeString(check, (CharSequence)stringWriter.toString(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        System.out.println("Saved debug check mappings to " + check);
    }
}

