/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.util.Locale;
import java.util.function.Supplier;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.LoomGradleExtensionAPI;
import org.gradle.api.GradleException;
import org.gradle.api.Project;

public enum ModPlatform {
    FABRIC("Fabric", false),
    FORGE("Forge", false),
    QUILT("Quilt", true),
    NEOFORGE("NeoForge", true);

    private final String displayName;
    boolean experimental;

    private ModPlatform(String displayName, boolean experimental) {
        this.displayName = displayName;
        this.experimental = experimental;
    }

    public String id() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String displayName() {
        return this.displayName;
    }

    public boolean isExperimental() {
        return this.experimental;
    }

    public boolean isForgeLike() {
        return this == FORGE || this == NEOFORGE;
    }

    public static void assertPlatform(Project project, ModPlatform platform) {
        ModPlatform.assertPlatform(LoomGradleExtension.get(project), platform);
    }

    public static void assertPlatform(LoomGradleExtensionAPI extension, ModPlatform platform) {
        ModPlatform.assertPlatform(extension, platform, () -> {
            String msg = "Loom is not running on %s.%nYou can switch to it by adding 'loom.platform = %s' to your gradle.properties";
            return msg.formatted(platform.displayName(), platform.id());
        });
    }

    public static void assertPlatform(LoomGradleExtensionAPI extension, ModPlatform platform, Supplier<String> message) {
        if (extension.getPlatform().get() != platform) {
            throw new GradleException(message.get());
        }
    }

    public static void assertForgeLike(LoomGradleExtensionAPI extension) {
        ModPlatform.assertForgeLike(extension, () -> "Loom is not running on a Forge-like platform (Forge or NeoForge).");
    }

    public static void assertForgeLike(LoomGradleExtensionAPI extension, Supplier<String> message) {
        if (!((ModPlatform)((Object)extension.getPlatform().get())).isForgeLike()) {
            throw new GradleException(message.get());
        }
    }
}

