/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ThreadingUtils {
    public static <T> void run(T[] values, UnsafeConsumer<T> action) {
        ThreadingUtils.run(Arrays.stream(values).map(t -> () -> action.accept(t)).collect(Collectors.toList()));
    }

    public static <T> void run(Collection<T> values, UnsafeConsumer<T> action) {
        ThreadingUtils.run(values.stream().map(t -> () -> action.accept(t)).collect(Collectors.toList()));
    }

    public static void run(UnsafeRunnable ... jobs) {
        ThreadingUtils.run(Arrays.asList(jobs));
    }

    public static void run(Collection<UnsafeRunnable> jobs) {
        try {
            ExecutorService service = Executors.newFixedThreadPool(Math.max(1, Math.min(jobs.size(), Runtime.getRuntime().availableProcessors())));
            LinkedList futures = new LinkedList();
            for (UnsafeRunnable unsafeRunnable : jobs) {
                futures.add(service.submit(() -> {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                }));
            }
            for (Future future : futures) {
                future.get();
            }
            service.shutdownNow();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, R> List<R> get(Collection<T> values, Function<T, R> action) {
        return ThreadingUtils.get(values.stream().map(t -> () -> action.apply(t)).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T> List<T> get(UnsafeCallable<T> ... jobs) {
        return ThreadingUtils.get(Arrays.asList(jobs));
    }

    public static <T> List<T> get(Collection<UnsafeCallable<T>> jobs) {
        try {
            ExecutorService service = Executors.newFixedThreadPool(Math.max(1, Math.min(jobs.size(), Runtime.getRuntime().availableProcessors())));
            LinkedList<Future<Object>> futures = new LinkedList<Future<Object>>();
            ArrayList result = new ArrayList();
            for (UnsafeCallable<T> unsafeCallable : jobs) {
                futures.add(service.submit(() -> {
                    try {
                        return runnable.call();
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                }));
            }
            for (Future future : futures) {
                result.add(future.get());
            }
            service.shutdownNow();
            return result;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static TaskCompleter taskCompleter() {
        return new TaskCompleter();
    }

    public static interface UnsafeConsumer<T> {
        public void accept(T var1) throws Throwable;
    }

    public static interface UnsafeRunnable {
        public void run() throws Throwable;
    }

    public static interface UnsafeCallable<T> {
        public T call() throws Throwable;
    }

    public static class TaskCompleter
    implements Function<Throwable, Void> {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        List<CompletableFuture<?>> tasks = new ArrayList();
        ExecutorService service = Executors.newFixedThreadPool(Math.max(1, Runtime.getRuntime().availableProcessors()));
        List<UnsafeConsumer<Stopwatch>> completionListener = new ArrayList<UnsafeConsumer<Stopwatch>>();

        public TaskCompleter add(UnsafeRunnable job) {
            if (!this.stopwatch.isRunning()) {
                this.stopwatch.start();
            }
            this.tasks.add((CompletableFuture<?>)CompletableFuture.runAsync(() -> {
                try {
                    job.run();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }, this.service).exceptionally((Function)this));
            return this;
        }

        public TaskCompleter onComplete(UnsafeConsumer<Stopwatch> consumer) {
            this.completionListener.add(consumer);
            return this;
        }

        public void complete() {
            try {
                ((CompletableFuture)CompletableFuture.allOf(this.tasks.toArray(new CompletableFuture[0])).exceptionally((Function)this)).get();
                this.service.shutdownNow();
                if (this.stopwatch.isRunning()) {
                    this.stopwatch.stop();
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    for (UnsafeConsumer<Stopwatch> consumer : this.completionListener) {
                        consumer.accept(this.stopwatch);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public Void apply(Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }
}

