/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.fmj;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.architectury.loom.metadata.ModMetadataFile;
import dev.architectury.loom.metadata.ModMetadataFiles;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.ModPlatform;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonSource;
import net.fabricmc.loom.util.fmj.FabricModJsonUtils;
import net.fabricmc.loom.util.fmj.FabricModJsonV0;
import net.fabricmc.loom.util.fmj.FabricModJsonV1;
import net.fabricmc.loom.util.fmj.FabricModJsonV2;
import net.fabricmc.loom.util.fmj.ModMetadataFabricModJson;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FabricModJsonFactory {
    public static final String FABRIC_MOD_JSON = "fabric.mod.json";
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricModJsonFactory.class);

    private FabricModJsonFactory() {
    }

    @VisibleForTesting
    public static FabricModJson create(JsonObject jsonObject, FabricModJsonSource source) {
        int schemaVersion = 0;
        if (jsonObject.has("schemaVersion")) {
            schemaVersion = FabricModJsonUtils.readInt(jsonObject, "schemaVersion");
        }
        return switch (schemaVersion) {
            case 0 -> new FabricModJsonV0(jsonObject, source);
            case 1 -> new FabricModJsonV1(jsonObject, source);
            case 2 -> new FabricModJsonV2(jsonObject, source);
            default -> throw new UnsupportedOperationException(String.format("This version of fabric-loom doesn't support the newer fabric.mod.json schema version of (%s) Please update fabric-loom to be able to read this.", schemaVersion));
        };
    }

    public static FabricModJson createFromZip(Path zipPath) {
        try {
            return FabricModJsonFactory.create(ZipUtils.unpackGson(zipPath, FABRIC_MOD_JSON, JsonObject.class), new FabricModJsonSource.ZipSource(zipPath));
        }
        catch (IOException e) {
            try {
                @Nullable ModMetadataFile modMetadata = ModMetadataFiles.fromJar(zipPath);
                if (modMetadata != null) {
                    return new ModMetadataFabricModJson(modMetadata, (FabricModJsonSource)new FabricModJsonSource.ZipSource(zipPath));
                }
            }
            catch (IOException e2) {
                UncheckedIOException unchecked = new UncheckedIOException("Failed to read mod metadata file in zip: " + zipPath, e2);
                unchecked.addSuppressed(e);
                throw unchecked;
            }
            throw new UncheckedIOException("Failed to read fabric.mod.json file in zip: " + zipPath, e);
        }
    }

    @Nullable
    public static FabricModJson createFromZipNullable(Path zipPath) {
        JsonObject jsonObject;
        try {
            jsonObject = ZipUtils.unpackGsonNullable(zipPath, FABRIC_MOD_JSON, JsonObject.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read zip: " + zipPath, e);
        }
        if (jsonObject == null) {
            try {
                @Nullable ModMetadataFile modMetadata = ModMetadataFiles.fromJar(zipPath);
                if (modMetadata != null) {
                    return new ModMetadataFabricModJson(modMetadata, (FabricModJsonSource)new FabricModJsonSource.ZipSource(zipPath));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read mod metadata file in zip: " + zipPath, e);
            }
            return null;
        }
        return FabricModJsonFactory.create(jsonObject, new FabricModJsonSource.ZipSource(zipPath));
    }

    public static Optional<FabricModJson> createFromZipOptional(Path zipPath) {
        return Optional.ofNullable(FabricModJsonFactory.createFromZipNullable(zipPath));
    }

    public static FabricModJson createFromDirectory(Path directory) throws IOException {
        ModMetadataFile modMetadata;
        Path path = directory.resolve(FABRIC_MOD_JSON);
        if (Files.notExists(path, new LinkOption[0]) && (modMetadata = ModMetadataFiles.fromDirectory(directory)) != null) {
            return new ModMetadataFabricModJson(modMetadata, (FabricModJsonSource)new FabricModJsonSource.DirectorySource(directory));
        }
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            FabricModJson fabricModJson = FabricModJsonFactory.create((JsonObject)LoomGradlePlugin.GSON.fromJson((Reader)reader, JsonObject.class), new FabricModJsonSource.DirectorySource(directory));
            return fabricModJson;
        }
    }

    @Nullable
    public static FabricModJson createFromSourceSetsNullable(SourceSet ... sourceSets) throws IOException {
        FabricModJson fabricModJson;
        block11: {
            File file = SourceSetHelper.findFirstFileInResource(FABRIC_MOD_JSON, sourceSets);
            if (file == null) {
                @Nullable ModMetadataFile modMetadata = ModMetadataFiles.fromSourceSets(sourceSets);
                if (modMetadata != null) {
                    return new ModMetadataFabricModJson(modMetadata, (FabricModJsonSource)new FabricModJsonSource.SourceSetSource(sourceSets));
                }
                return null;
            }
            BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);
            try {
                fabricModJson = FabricModJsonFactory.create((JsonObject)LoomGradlePlugin.GSON.fromJson((Reader)reader, JsonObject.class), new FabricModJsonSource.SourceSetSource(sourceSets));
                if (reader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonSyntaxException e) {
                    LOGGER.warn("Failed to parse fabric.mod.json: {}", (Object)file.getAbsolutePath());
                    return null;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to read " + file.getAbsolutePath(), e);
                }
            }
            ((Reader)reader).close();
        }
        return fabricModJson;
    }

    public static boolean isModJar(File file, ModPlatform platform) {
        return FabricModJsonFactory.isModJar(file.toPath(), platform);
    }

    public static boolean isModJar(Path input, ModPlatform platform) {
        if (platform.isForgeLike()) {
            return ZipUtils.contains(input, "META-INF/mods.toml") || platform == ModPlatform.NEOFORGE && ZipUtils.contains(input, "META-INF/neoforge.mods.toml");
        }
        if (platform == ModPlatform.QUILT) {
            return ZipUtils.contains(input, "quilt.mod.json") || FabricModJsonFactory.isModJar(input, ModPlatform.FABRIC);
        }
        return ZipUtils.contains(input, FABRIC_MOD_JSON);
    }

    public static boolean isNestableModJar(File file, ModPlatform platform) {
        return FabricModJsonFactory.isNestableModJar(file.toPath(), platform);
    }

    public static boolean isNestableModJar(Path input, ModPlatform platform) {
        if (platform.isForgeLike()) {
            return true;
        }
        return FabricModJsonFactory.isModJar(input, platform);
    }

    public static boolean containsMod(FileSystemUtil.Delegate fs, ModPlatform platform) {
        if (Files.exists(fs.getPath("architectury.common.marker", new String[0]), new LinkOption[0])) {
            return true;
        }
        if (platform.isForgeLike()) {
            return Files.exists(fs.getPath("META-INF/mods.toml", new String[0]), new LinkOption[0]) || platform == ModPlatform.NEOFORGE && Files.exists(fs.getPath("META-INF/neoforge.mods.toml", new String[0]), new LinkOption[0]);
        }
        if (platform == ModPlatform.QUILT) {
            return Files.exists(fs.getPath("quilt.mod.json", new String[0]), new LinkOption[0]) || FabricModJsonFactory.containsMod(fs, ModPlatform.FABRIC);
        }
        return Files.exists(fs.getPath(FABRIC_MOD_JSON, new String[0]), new LinkOption[0]);
    }
}

