/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.gradle;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.Transformer;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.WorkerDaemonClientsManager;

public class WorkerDaemonClientsManagerHelper {
    public static final String MARKER_PROP = "fabric.loom.decompile.worker";

    public static boolean stopIdleJVM(WorkerDaemonClientsManager manager, String jvmMarkerValue) {
        AtomicBoolean stopped = new AtomicBoolean(false);
        Transformer transformer = workerDaemonClients -> {
            for (Object client : workerDaemonClients) {
                DaemonForkOptions forkOptions = WorkerDaemonClientsManagerHelper.getForkOptions(client);
                Map systemProperties = forkOptions.getJavaForkOptions().getSystemProperties();
                if (systemProperties == null || !jvmMarkerValue.equals(systemProperties.get(MARKER_PROP))) continue;
                stopped.set(true);
                return Collections.singletonList(client);
            }
            return Collections.emptyList();
        };
        manager.selectIdleClientsToStop(transformer);
        return stopped.get();
    }

    private static DaemonForkOptions getForkOptions(Object client) {
        try {
            Method getForkOptionsMethod = client.getClass().getDeclaredMethod("getForkOptions", new Class[0]);
            getForkOptionsMethod.setAccessible(true);
            return (DaemonForkOptions)getForkOptionsMethod.invoke(client, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

