/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.sign.work;

import dev.sigstore.KeylessSigner;
import dev.sigstore.bundle.Bundle;
import dev.sigstore.oidc.client.OidcClient;
import dev.sigstore.oidc.client.OidcClients;
import dev.sigstore.sign.OidcClientConfiguration;
import dev.sigstore.sign.work.SignWorkParameters;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.RegularFile;
import org.gradle.workers.WorkAction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0012\u0010\u0004\u001a\u00020\u0002X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Ldev/sigstore/sign/work/SignWorkAction;", "Lorg/gradle/workers/WorkAction;", "Ldev/sigstore/sign/work/SignWorkParameters;", "()V", "parameters", "getParameters", "()Ldev/sigstore/sign/work/SignWorkParameters;", "execute", "", "Companion", "sigstore-gradle-sign-base-plugin"})
public abstract class SignWorkAction
implements WorkAction<SignWorkParameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = LoggerFactory.getLogger(SignWorkAction.class);
    @NotNull
    private static final ConcurrentHashMap<Object, KeylessSigner> clients = new ConcurrentHashMap();
    @NotNull
    public static final String DEFAULT_KEY = "_default";

    @NotNull
    public abstract SignWorkParameters getParameters();

    public void execute() {
        File file = ((RegularFile)this.getParameters().getInputFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parameters.inputFile.get().asFile");
        File inputFile = file;
        logger.info("Signing in Sigstore: {}", (Object)inputFile);
        String signerKey = this.getParameters().getOidcClient().isPresent() ? ((OidcClientConfiguration)this.getParameters().getOidcClient().get()).key() : DEFAULT_KEY;
        KeylessSigner keylessSigner = clients.computeIfAbsent(signerKey, new Function(signerKey, this){
            final /* synthetic */ Object $signerKey;
            final /* synthetic */ SignWorkAction this$0;
            {
                this.$signerKey = $signerKey;
                this.this$0 = $receiver;
            }

            public final KeylessSigner apply(Object it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                KeylessSigner.Builder builder = KeylessSigner.builder();
                Object object = this.$signerKey;
                SignWorkAction signWorkAction = this.this$0;
                KeylessSigner.Builder $this$apply_u24lambda_u240 = builder;
                boolean bl = false;
                $this$apply_u24lambda_u240.sigstorePublicDefaults();
                if (!Intrinsics.areEqual((Object)object, (Object)"_default")) {
                    OidcClient[] oidcClientArray = new OidcClient[1];
                    Intrinsics.checkNotNull((Object)((OidcClientConfiguration)signWorkAction.getParameters().getOidcClient().get()).build(), (String)"null cannot be cast to non-null type dev.sigstore.oidc.client.OidcClient");
                    $this$apply_u24lambda_u240.forceCredentialProviders(OidcClients.of((OidcClient[])oidcClientArray));
                }
                return builder.build();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)keylessSigner, (String)"override fun execute() {\u2026iteText(bundleJson)\n    }");
        KeylessSigner signer2 = keylessSigner;
        Bundle result = signer2.signFile(inputFile.toPath());
        String bundleJson = result.toJson();
        File file2 = ((RegularFile)this.getParameters().getOutputSignature().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"parameters.outputSignature.get().asFile");
        Intrinsics.checkNotNullExpressionValue((Object)bundleJson, (String)"bundleJson");
        FilesKt.writeText$default((File)file2, (String)bundleJson, null, (int)2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/sigstore/sign/work/SignWorkAction$Companion;", "", "()V", "DEFAULT_KEY", "", "clients", "Ljava/util/concurrent/ConcurrentHashMap;", "Ldev/sigstore/KeylessSigner;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sigstore-gradle-sign-base-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

