/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;

public class AlgorithmRegistry {

    public static enum HashAlgorithm {
        SHA2_256("SHA256", 32, Hashing.sha256());

        private final String name;
        private final int length;
        private final HashFunction hashFunction;

        private HashAlgorithm(String name, int length, HashFunction hashFunction) {
            this.name = name;
            this.length = length;
            this.hashFunction = hashFunction;
        }

        public String toString() {
            return this.name;
        }

        public int getLength() {
            return this.length;
        }

        HashFunction getHashFunction() {
            return this.hashFunction;
        }
    }

    public static enum SigningAlgorithm {
        PKIX_RSA_PKCS1V15_2048_SHA256(HashAlgorithm.SHA2_256),
        PKIX_RSA_PKCS1V15_3072_SHA256(HashAlgorithm.SHA2_256),
        PKIX_RSA_PKCS1V15_4096_SHA256(HashAlgorithm.SHA2_256),
        PKIX_ECDSA_P256_SHA_256(HashAlgorithm.SHA2_256);

        private final HashAlgorithm hashAlgorithm;

        private SigningAlgorithm(HashAlgorithm hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
        }

        public HashAlgorithm getHashing() {
            return this.hashAlgorithm;
        }
    }
}

