/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore;

import com.google.api.client.util.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.protobuf.ByteString;
import dev.sigstore.AlgorithmRegistry;
import dev.sigstore.KeylessSignerException;
import dev.sigstore.SigningConfigProvider;
import dev.sigstore.TrustedRootProvider;
import dev.sigstore.bundle.Bundle;
import dev.sigstore.bundle.ImmutableBundle;
import dev.sigstore.bundle.ImmutableTimestamp;
import dev.sigstore.encryption.certificates.Certificates;
import dev.sigstore.encryption.signers.Signer;
import dev.sigstore.encryption.signers.Signers;
import dev.sigstore.fulcio.client.CertificateRequest;
import dev.sigstore.fulcio.client.FulcioClient;
import dev.sigstore.fulcio.client.FulcioClientGrpc;
import dev.sigstore.fulcio.client.FulcioVerificationException;
import dev.sigstore.fulcio.client.FulcioVerifier;
import dev.sigstore.fulcio.client.UnsupportedAlgorithmException;
import dev.sigstore.oidc.client.OidcClients;
import dev.sigstore.oidc.client.OidcException;
import dev.sigstore.oidc.client.OidcToken;
import dev.sigstore.oidc.client.OidcTokenMatcher;
import dev.sigstore.proto.ProtoMutators;
import dev.sigstore.proto.common.v1.X509Certificate;
import dev.sigstore.proto.rekor.v2.HashedRekordRequestV002;
import dev.sigstore.proto.rekor.v2.Signature;
import dev.sigstore.proto.rekor.v2.Verifier;
import dev.sigstore.rekor.client.HashedRekordRequest;
import dev.sigstore.rekor.client.RekorClient;
import dev.sigstore.rekor.client.RekorClientHttp;
import dev.sigstore.rekor.client.RekorEntry;
import dev.sigstore.rekor.client.RekorParseException;
import dev.sigstore.rekor.client.RekorResponse;
import dev.sigstore.rekor.client.RekorVerificationException;
import dev.sigstore.rekor.client.RekorVerifier;
import dev.sigstore.rekor.v2.client.RekorV2Client;
import dev.sigstore.rekor.v2.client.RekorV2ClientHttp;
import dev.sigstore.timestamp.client.HashAlgorithm;
import dev.sigstore.timestamp.client.ImmutableTimestampRequest;
import dev.sigstore.timestamp.client.TimestampClient;
import dev.sigstore.timestamp.client.TimestampClientHttp;
import dev.sigstore.timestamp.client.TimestampException;
import dev.sigstore.timestamp.client.TimestampResponse;
import dev.sigstore.timestamp.client.TimestampVerificationException;
import dev.sigstore.timestamp.client.TimestampVerifier;
import dev.sigstore.trustroot.Service;
import dev.sigstore.trustroot.SigstoreConfigurationException;
import dev.sigstore.trustroot.SigstoreSigningConfig;
import dev.sigstore.trustroot.SigstoreTrustedRoot;
import dev.sigstore.tuf.SigstoreTufClient;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Base64;

public class KeylessSigner
implements AutoCloseable {
    public static final Duration DEFAULT_MIN_SIGNING_CERTIFICATE_LIFETIME = Duration.ofMinutes(5L);
    private final FulcioClient fulcioClient;
    private final FulcioVerifier fulcioVerifier;
    private final RekorClient rekorClient;
    private final RekorV2Client rekorV2Client;
    private final RekorVerifier rekorVerifier;
    private final TimestampClient timestampClient;
    private final TimestampVerifier timestampVerifier;
    private final OidcClients oidcClients;
    private final List<OidcTokenMatcher> oidcIdentities;
    private final Signer signer;
    private final AlgorithmRegistry.SigningAlgorithm signingAlgorithm;
    private final Duration minSigningCertificateLifetime;
    @Nullable
    @GuardedBy(value="lock")
    private CertPath signingCert;
    @Nullable
    @GuardedBy(value="lock")
    private byte[] signingCertPemBytes;
    @Nullable
    @GuardedBy(value="lock")
    private byte[] encodedCert;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private KeylessSigner(FulcioClient fulcioClient, FulcioVerifier fulcioVerifier, RekorClient rekorClient, RekorV2Client rekorV2Client, RekorVerifier rekorVerifier, TimestampClient timestampClient, TimestampVerifier timestampVerifier, OidcClients oidcClients, List<OidcTokenMatcher> oidcIdentities, Signer signer, AlgorithmRegistry.SigningAlgorithm signingAlgorithm, Duration minSigningCertificateLifetime) {
        this.fulcioClient = fulcioClient;
        this.fulcioVerifier = fulcioVerifier;
        this.rekorClient = rekorClient;
        this.rekorV2Client = rekorV2Client;
        this.rekorVerifier = rekorVerifier;
        this.timestampClient = timestampClient;
        this.timestampVerifier = timestampVerifier;
        this.oidcClients = oidcClients;
        this.oidcIdentities = oidcIdentities;
        this.signer = signer;
        this.signingAlgorithm = signingAlgorithm;
        this.minSigningCertificateLifetime = minSigningCertificateLifetime;
    }

    @Override
    public void close() {
        this.lock.writeLock().lock();
        try {
            this.signingCert = null;
            this.signingCertPemBytes = null;
            this.encodedCert = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @CheckReturnValue
    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public List<Bundle> sign(List<byte[]> artifactDigests) throws KeylessSignerException {
        if (artifactDigests.isEmpty()) {
            throw new IllegalArgumentException("Require one or more digests");
        }
        for (byte[] digest : artifactDigests) {
            if (this.signingAlgorithm.getHashing().getLength() == digest.length) continue;
            throw new KeylessSignerException("Invalid digest length: " + digest.length + " for signing Algorithm " + String.valueOf((Object)this.signingAlgorithm));
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (byte[] artifactDigest : artifactDigests) {
            byte[] encodedCert;
            byte[] signingCertPemBytes;
            CertPath signingCert;
            byte[] signature;
            try {
                signature = this.signer.signDigest(artifactDigest);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
                throw new KeylessSignerException("Failed to sign artifact", ex);
            }
            try {
                this.renewSigningCertificate();
            }
            catch (FulcioVerificationException | UnsupportedAlgorithmException | OidcException | IOException | InterruptedException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateException ex) {
                throw new KeylessSignerException("Failed to obtain signing certificate", ex);
            }
            this.lock.readLock().lock();
            try {
                signingCert = this.signingCert;
                signingCertPemBytes = this.signingCertPemBytes;
                encodedCert = this.encodedCert;
                if (signingCert == null) {
                    throw new IllegalStateException("Signing certificate is null");
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            ImmutableBundle.Builder bundleBuilder = ImmutableBundle.builder().certPath(signingCert).messageSignature(Bundle.MessageSignature.of(this.signingAlgorithm.getHashing(), artifactDigest, signature));
            if (this.rekorV2Client != null) {
                RekorEntry entry;
                TimestampResponse tsResp;
                Preconditions.checkNotNull((Object)this.timestampClient, (Object)"Timestamp client must be configured for Rekor v2");
                Preconditions.checkNotNull((Object)this.timestampVerifier, (Object)"Timestamp verifier must be configured for Rekor v2");
                byte[] signatureDigest = Hashing.sha256().hashBytes(signature).asBytes();
                ImmutableTimestampRequest tsReq = ImmutableTimestampRequest.builder().hashAlgorithm(HashAlgorithm.SHA256).hash(signatureDigest).build();
                try {
                    tsResp = this.timestampClient.timestamp(tsReq);
                }
                catch (TimestampException ex) {
                    throw new KeylessSignerException("Failed to generate timestamp", ex);
                }
                try {
                    this.timestampVerifier.verify(tsResp, signature);
                }
                catch (TimestampVerificationException ex) {
                    throw new KeylessSignerException("Returned timestamp was invalid", ex);
                }
                ImmutableTimestamp timestamp = ImmutableTimestamp.builder().rfc3161Timestamp(tsResp.getEncoded()).build();
                bundleBuilder.addTimestamps((Bundle.Timestamp)timestamp);
                Verifier verifier = Verifier.newBuilder().setX509Certificate(X509Certificate.newBuilder().setRawBytes(ByteString.copyFrom((byte[])encodedCert)).build()).setKeyDetails(ProtoMutators.toPublicKeyDetails(this.signingAlgorithm)).build();
                Signature reqSignature = Signature.newBuilder().setContent(ByteString.copyFrom((byte[])signature)).setVerifier(verifier).build();
                HashedRekordRequestV002 hashedRekordRequest = HashedRekordRequestV002.newBuilder().setDigest(ByteString.copyFrom((byte[])artifactDigest)).setSignature(reqSignature).build();
                try {
                    entry = this.rekorV2Client.putEntry(hashedRekordRequest);
                }
                catch (RekorParseException | IOException ex) {
                    throw new KeylessSignerException("Failed to put entry in rekor", ex);
                }
                try {
                    ArrayList<Instant> timestamps = new ArrayList<Instant>();
                    timestamps.add(tsResp.getGenTime().toInstant());
                    if (entry.getIntegratedTime() != 0L) {
                        timestamps.add(entry.getIntegratedTimeInstant());
                    }
                    this.rekorVerifier.verifyEntry(entry);
                }
                catch (RekorVerificationException | TimestampException ex) {
                    throw new KeylessSignerException("Failed to validate rekor entry after signing", ex);
                }
                bundleBuilder.addEntries(entry);
            } else if (this.rekorClient != null) {
                RekorResponse rekorResponse;
                HashedRekordRequest rekorRequest = HashedRekordRequest.newHashedRekordRequest(artifactDigest, signingCertPemBytes, signature);
                try {
                    rekorResponse = this.rekorClient.putEntry(rekorRequest);
                }
                catch (RekorParseException | IOException ex) {
                    throw new KeylessSignerException("Failed to put entry in rekor", ex);
                }
                String calculatedHashedRekord = Base64.toBase64String((byte[])rekorRequest.toJsonPayload().getBytes(StandardCharsets.UTF_8));
                if (!Objects.equals(calculatedHashedRekord, rekorResponse.getEntry().getBody())) {
                    throw new KeylessSignerException("Returned log entry was inconsistent with request");
                }
                try {
                    this.rekorVerifier.verifyEntry(rekorResponse.getEntry());
                }
                catch (RekorVerificationException ex) {
                    throw new KeylessSignerException("Failed to validate rekor response after signing", ex);
                }
                bundleBuilder.addEntries(rekorResponse.getEntry());
            } else {
                throw new IllegalStateException("No rekor client was configured.");
            }
            result.add((Object)bundleBuilder.build());
        }
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renewSigningCertificate() throws InterruptedException, CertificateException, IOException, UnsupportedAlgorithmException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, FulcioVerificationException, OidcException, KeylessSignerException {
        this.lock.readLock().lock();
        try {
            long lifetimeLeft;
            if (this.signingCert != null && (lifetimeLeft = Certificates.getLeaf(this.signingCert).getNotAfter().getTime() - System.currentTimeMillis()) > this.minSigningCertificateLifetime.toMillis()) {
                return;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            this.signingCert = null;
            this.signingCertPemBytes = null;
            this.encodedCert = null;
            OidcToken tokenInfo = this.oidcClients.getIDToken();
            if (!this.oidcIdentities.isEmpty() && this.oidcIdentities.stream().noneMatch(id -> id.test(tokenInfo))) {
                throw new KeylessSignerException("Obtained Oidc Token " + String.valueOf(tokenInfo) + " does not match any identities in allow list");
            }
            CertPath renewedSigningCert = this.fulcioClient.signingCertificate(CertificateRequest.newCertificateRequest(this.signer.getPublicKey(), tokenInfo.getIdToken(), this.signer.sign(tokenInfo.getSubjectAlternativeName().getBytes(StandardCharsets.UTF_8))));
            CertPath trimmed = this.fulcioVerifier.trimTrustedParent(renewedSigningCert);
            this.fulcioVerifier.verifySigningCertificate(trimmed);
            this.signingCert = trimmed;
            this.signingCertPemBytes = Certificates.toPemBytes(this.signingCert);
            this.encodedCert = Certificates.getLeaf(this.signingCert).getEncoded();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @CheckReturnValue
    public Bundle sign(byte[] artifactDigest) throws KeylessSignerException {
        return this.sign(List.of(artifactDigest)).get(0);
    }

    @CheckReturnValue
    public Map<Path, Bundle> signFiles(List<Path> artifacts) throws KeylessSignerException {
        if (artifacts.isEmpty()) {
            throw new IllegalArgumentException("Require one or more paths");
        }
        ArrayList<byte[]> digests = new ArrayList<byte[]>(artifacts.size());
        for (Path artifact : artifacts) {
            ByteSource artifactByteSource = Files.asByteSource((File)artifact.toFile());
            try {
                digests.add(artifactByteSource.hash(this.signingAlgorithm.getHashing().getHashFunction()).asBytes());
            }
            catch (IOException ex) {
                throw new KeylessSignerException("Failed to hash artifact " + String.valueOf(artifact));
            }
        }
        List<Bundle> signingResult = this.sign(digests);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (int i = 0; i < artifacts.size(); ++i) {
            result.put((Object)artifacts.get(i), (Object)signingResult.get(i));
        }
        return result.build();
    }

    @CheckReturnValue
    public Bundle signFile(Path artifact) throws KeylessSignerException {
        return this.signFiles(List.of(artifact)).get(artifact);
    }

    public static class Builder {
        private TrustedRootProvider trustedRootProvider;
        private SigningConfigProvider signingConfigProvider;
        private OidcClients oidcClients;
        private List<OidcTokenMatcher> oidcIdentities = Collections.emptyList();
        private AlgorithmRegistry.SigningAlgorithm signingAlgorithm;
        private Duration minSigningCertificateLifetime = DEFAULT_MIN_SIGNING_CERTIFICATE_LIFETIME;
        private boolean enableRekorV2 = false;

        @CanIgnoreReturnValue
        public Builder trustedRootProvider(TrustedRootProvider trustedRootProvider) {
            this.trustedRootProvider = trustedRootProvider;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder signingConfigProvider(SigningConfigProvider signingConfigProvider) {
            this.signingConfigProvider = signingConfigProvider;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder enableRekorV2(boolean enableRekorV2) {
            this.enableRekorV2 = enableRekorV2;
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder oidcClients(OidcClients oidcClients) {
            return this.forceCredentialProviders(oidcClients);
        }

        @CanIgnoreReturnValue
        public Builder forceCredentialProviders(OidcClients oidcClients) {
            this.oidcClients = oidcClients;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowedOidcIdentities(List<OidcTokenMatcher> oidcIdentities) {
            this.oidcIdentities = ImmutableList.copyOf(oidcIdentities);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder signingAlgorithm(AlgorithmRegistry.SigningAlgorithm signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder minSigningCertificateLifetime(Duration minSigningCertificateLifetime) {
            this.minSigningCertificateLifetime = minSigningCertificateLifetime;
            return this;
        }

        @CheckReturnValue
        public KeylessSigner build() throws CertificateException, IOException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException, SigstoreConfigurationException {
            Preconditions.checkNotNull((Object)this.trustedRootProvider);
            SigstoreTrustedRoot trustedRoot = this.trustedRootProvider.get();
            Preconditions.checkNotNull((Object)this.signingConfigProvider);
            SigstoreSigningConfig signingConfig = this.signingConfigProvider.get();
            Preconditions.checkNotNull(this.oidcIdentities);
            Preconditions.checkNotNull((Object)((Object)this.signingAlgorithm));
            Preconditions.checkNotNull((Object)this.minSigningCertificateLifetime);
            Optional<Service> fulcioService = Service.select(signingConfig.getCas(), List.of(Integer.valueOf(1)));
            if (fulcioService.isEmpty()) {
                throw new SigstoreConfigurationException("No suitable fulcio target was found in signing config");
            }
            FulcioClientGrpc fulcioClient = FulcioClientGrpc.builder().setService(fulcioService.get()).build();
            FulcioVerifier fulcioVerifier = FulcioVerifier.newFulcioVerifier(trustedRoot);
            Optional<Service> rekorService = Service.select(signingConfig.getTLogs(), this.enableRekorV2 ? List.of(Integer.valueOf(1), Integer.valueOf(2)) : List.of(Integer.valueOf(1)));
            if (rekorService.isEmpty()) {
                throw new SigstoreConfigurationException("No suitable rekor target was found in signing config");
            }
            RekorClientHttp rekorClient = null;
            RekorV2ClientHttp rekorV2Client = null;
            if (rekorService.get().getApiVersion() == 1) {
                rekorClient = RekorClientHttp.builder().setService(rekorService.get()).build();
            } else {
                rekorV2Client = RekorV2ClientHttp.builder().setService(rekorService.get()).build();
            }
            RekorVerifier rekorVerifier = RekorVerifier.newRekorVerifier(trustedRoot);
            TimestampClientHttp timestampClient = null;
            TimestampVerifier timestampVerifier = null;
            Optional<Service> timestampService = Service.select(signingConfig.getTsas(), List.of(Integer.valueOf(1)));
            if (timestampService.isEmpty()) {
                if (rekorService.get().getApiVersion() != 1) {
                    throw new SigstoreConfigurationException("No suitable tsa target was found in signing config");
                }
            } else {
                timestampClient = TimestampClientHttp.builder().setService(timestampService.get()).build();
                timestampVerifier = TimestampVerifier.newTimestampVerifier(trustedRoot);
            }
            if (this.oidcClients == null) {
                Optional<Service> oidcService = Service.select(signingConfig.getOidcProviders(), List.of(Integer.valueOf(1)));
                if (oidcService.isEmpty()) {
                    throw new SigstoreConfigurationException("No suitable oidc target was found in signing config");
                }
                this.oidcClients = OidcClients.from(oidcService.get());
            }
            if (!this.signingAlgorithm.getHashing().equals((Object)AlgorithmRegistry.HashAlgorithm.SHA2_256)) {
                throw new SigstoreConfigurationException("Signing algorithm must use sha256");
            }
            Signer signer = Signers.from(this.signingAlgorithm);
            return new KeylessSigner(fulcioClient, fulcioVerifier, rekorClient, rekorV2Client, rekorVerifier, timestampClient, timestampVerifier, this.oidcClients, this.oidcIdentities, signer, this.signingAlgorithm, this.minSigningCertificateLifetime);
        }

        @CanIgnoreReturnValue
        public Builder sigstorePublicDefaults() {
            SigstoreTufClient.Builder sigstoreTufClientBuilder = SigstoreTufClient.builder().usePublicGoodInstance();
            this.trustedRootProvider = TrustedRootProvider.from(sigstoreTufClientBuilder);
            this.signingConfigProvider = SigningConfigProvider.from(sigstoreTufClientBuilder);
            this.signingAlgorithm = AlgorithmRegistry.SigningAlgorithm.PKIX_ECDSA_P256_SHA_256;
            this.minSigningCertificateLifetime(DEFAULT_MIN_SIGNING_CERTIFICATE_LIFETIME);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder sigstoreStagingDefaults() {
            SigstoreTufClient.Builder sigstoreTufClientBuilder = SigstoreTufClient.builder().useStagingInstance();
            this.trustedRootProvider = TrustedRootProvider.from(sigstoreTufClientBuilder);
            this.signingConfigProvider = SigningConfigProvider.from(sigstoreTufClientBuilder);
            this.signingAlgorithm = AlgorithmRegistry.SigningAlgorithm.PKIX_ECDSA_P256_SHA_256;
            this.minSigningCertificateLifetime(DEFAULT_MIN_SIGNING_CERTIFICATE_LIFETIME);
            return this;
        }
    }
}

