/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore;

import com.google.common.base.Preconditions;
import dev.sigstore.trustroot.SigstoreConfigurationException;
import dev.sigstore.trustroot.SigstoreSigningConfig;
import dev.sigstore.tuf.SigstoreTufClient;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

@FunctionalInterface
public interface SigningConfigProvider {
    public SigstoreSigningConfig get() throws SigstoreConfigurationException;

    public static SigningConfigProvider from(SigstoreTufClient.Builder tufClientBuilder) {
        Preconditions.checkNotNull((Object)tufClientBuilder);
        return () -> {
            try {
                SigstoreTufClient tufClient = tufClientBuilder.build();
                tufClient.update();
                return tufClient.getSigstoreSigningConfig();
            }
            catch (IOException ex) {
                throw new SigstoreConfigurationException("Could not initialize signing config from provided tuf client", ex);
            }
        };
    }

    public static SigningConfigProvider from(Path signingConfig) {
        Preconditions.checkNotNull((Object)signingConfig);
        return () -> {
            SigstoreSigningConfig sigstoreSigningConfig;
            block8: {
                InputStream is = Files.newInputStream(signingConfig, new OpenOption[0]);
                try {
                    sigstoreSigningConfig = SigstoreSigningConfig.from(is);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new SigstoreConfigurationException("Could not initialize signing config from " + String.valueOf(signingConfig), ex);
                    }
                }
                is.close();
            }
            return sigstoreSigningConfig;
        };
    }
}

