/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore;

import com.google.common.base.Preconditions;
import dev.sigstore.trustroot.SigstoreConfigurationException;
import dev.sigstore.trustroot.SigstoreTrustedRoot;
import dev.sigstore.tuf.SigstoreTufClient;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

@FunctionalInterface
public interface TrustedRootProvider {
    public SigstoreTrustedRoot get() throws SigstoreConfigurationException;

    public static TrustedRootProvider from(SigstoreTufClient.Builder tufClientBuilder) {
        Preconditions.checkNotNull((Object)tufClientBuilder);
        return () -> {
            try {
                SigstoreTufClient tufClient = tufClientBuilder.build();
                tufClient.update();
                return tufClient.getSigstoreTrustedRoot();
            }
            catch (IOException ex) {
                throw new SigstoreConfigurationException("Could not initialize trusted root from provided tuf client", ex);
            }
        };
    }

    public static TrustedRootProvider from(Path trustedRoot) {
        Preconditions.checkNotNull((Object)trustedRoot);
        return () -> {
            SigstoreTrustedRoot sigstoreTrustedRoot;
            block8: {
                InputStream is = Files.newInputStream(trustedRoot, new OpenOption[0]);
                try {
                    sigstoreTrustedRoot = SigstoreTrustedRoot.from(is);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new SigstoreConfigurationException("Could not initialize trusted root from " + String.valueOf(trustedRoot), ex);
                    }
                }
                is.close();
            }
            return sigstoreTrustedRoot;
        };
    }
}

