/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.bundle;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.bundle.Bundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Bundle.MessageSignature", generator="Immutables")
@Immutable
public final class ImmutableMessageSignature
implements Bundle.MessageSignature {
    @Nullable
    private final Bundle.MessageDigest messageDigest;
    private final byte[] signature;

    private ImmutableMessageSignature(@Nullable Bundle.MessageDigest messageDigest, byte[] signature) {
        this.messageDigest = messageDigest;
        this.signature = signature;
    }

    @Override
    public Optional<Bundle.MessageDigest> getMessageDigest() {
        return Optional.ofNullable(this.messageDigest);
    }

    @Override
    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    public final ImmutableMessageSignature withMessageDigest(Bundle.MessageDigest value) {
        Bundle.MessageDigest newValue = Objects.requireNonNull(value, "messageDigest");
        if (this.messageDigest == newValue) {
            return this;
        }
        return new ImmutableMessageSignature(newValue, this.signature);
    }

    public final ImmutableMessageSignature withMessageDigest(Optional<? extends Bundle.MessageDigest> optional) {
        Bundle.MessageDigest value = optional.orElse(null);
        if (this.messageDigest == value) {
            return this;
        }
        return new ImmutableMessageSignature(value, this.signature);
    }

    public final ImmutableMessageSignature withSignature(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableMessageSignature(this.messageDigest, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageSignature && this.equalTo(0, (ImmutableMessageSignature)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageSignature another) {
        return Objects.equals(this.messageDigest, another.messageDigest) && Arrays.equals(this.signature, another.signature);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.messageDigest);
        h += (h << 5) + Arrays.hashCode(this.signature);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MessageSignature").omitNullValues().add("messageDigest", (Object)this.messageDigest).add("signature", (Object)Arrays.toString(this.signature)).toString();
    }

    public static ImmutableMessageSignature copyOf(Bundle.MessageSignature instance) {
        if (instance instanceof ImmutableMessageSignature) {
            return (ImmutableMessageSignature)instance;
        }
        return ImmutableMessageSignature.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Bundle.MessageSignature", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SIGNATURE = 1L;
        private long initBits = 1L;
        @Nullable
        private Bundle.MessageDigest messageDigest;
        @Nullable
        private byte[] signature;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Bundle.MessageSignature instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<Bundle.MessageDigest> messageDigestOptional = instance.getMessageDigest();
            if (messageDigestOptional.isPresent()) {
                this.messageDigest(messageDigestOptional);
            }
            this.signature(instance.getSignature());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder messageDigest(Bundle.MessageDigest messageDigest) {
            this.messageDigest = Objects.requireNonNull(messageDigest, "messageDigest");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder messageDigest(Optional<? extends Bundle.MessageDigest> messageDigest) {
            this.messageDigest = messageDigest.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signature(byte ... signature) {
            this.signature = (byte[])signature.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMessageSignature build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageSignature(this.messageDigest, this.signature);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("signature");
            }
            return "Cannot build MessageSignature, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

