/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.dsse;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import dev.sigstore.dsse.ImmutableInTotoPayload;
import dev.sigstore.dsse.ImmutableSubject;
import dev.sigstore.dsse.InTotoPayload;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="dev.sigstore.dsse", generator="Gsons")
public final class GsonAdaptersInTotoPayload
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (SubjectTypeAdapter.adapts(type)) {
            return new SubjectTypeAdapter(gson);
        }
        if (InTotoPayloadTypeAdapter.adapts(type)) {
            return new InTotoPayloadTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersInTotoPayload(Subject, InTotoPayload)";
    }

    @Generated(from="InTotoPayload.Subject", generator="Gsons")
    private static class SubjectTypeAdapter
    extends TypeAdapter<InTotoPayload.Subject> {
        SubjectTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return InTotoPayload.Subject.class == type.getRawType() || ImmutableSubject.class == type.getRawType();
        }

        public void write(JsonWriter out, InTotoPayload.Subject value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeSubject(out, value);
            }
        }

        public InTotoPayload.Subject read(JsonReader in) throws IOException {
            return this.readSubject(in);
        }

        private void writeSubject(JsonWriter out, InTotoPayload.Subject instance) throws IOException {
            out.beginObject();
            out.name("name");
            out.value(instance.getName());
            Map<String, String> digestMapping = instance.getDigest();
            out.name("digest");
            out.beginObject();
            for (Map.Entry<String, String> e : digestMapping.entrySet()) {
                String key = e.getKey();
                out.name(key);
                String value = e.getValue();
                out.value(value);
            }
            out.endObject();
            out.endObject();
        }

        private InTotoPayload.Subject readSubject(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableSubject.Builder builder = ImmutableSubject.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableSubject.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'n': {
                    if (!"name".equals(attributeName)) break;
                    this.readInName(in, builder);
                    return;
                }
                case 'd': {
                    if (!"digest".equals(attributeName)) break;
                    this.readInDigest(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInName(JsonReader in, ImmutableSubject.Builder builder) throws IOException {
            builder.name(in.nextString());
        }

        private void readInDigest(JsonReader in, ImmutableSubject.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    String value = in.nextString();
                    builder.putDigest(key, value);
                }
                in.endObject();
            }
        }
    }

    @Generated(from="InTotoPayload", generator="Gsons")
    private static class InTotoPayloadTypeAdapter
    extends TypeAdapter<InTotoPayload> {
        public final InTotoPayload.Subject subjectTypeSample = null;
        public final JsonElement predicateTypeSample = null;
        private final TypeAdapter<InTotoPayload.Subject> subjectTypeAdapter;
        private final TypeAdapter<JsonElement> predicateTypeAdapter;

        InTotoPayloadTypeAdapter(Gson gson) {
            this.subjectTypeAdapter = gson.getAdapter(InTotoPayload.Subject.class);
            this.predicateTypeAdapter = gson.getAdapter(JsonElement.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return InTotoPayload.class == type.getRawType() || ImmutableInTotoPayload.class == type.getRawType();
        }

        public void write(JsonWriter out, InTotoPayload value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeInTotoPayload(out, value);
            }
        }

        public InTotoPayload read(JsonReader in) throws IOException {
            return this.readInTotoPayload(in);
        }

        private void writeInTotoPayload(JsonWriter out, InTotoPayload instance) throws IOException {
            out.beginObject();
            out.name("_type");
            out.value(instance.getType());
            List<InTotoPayload.Subject> subjectElements = instance.getSubject();
            out.name("subject");
            out.beginArray();
            for (InTotoPayload.Subject e : subjectElements) {
                this.subjectTypeAdapter.write(out, (Object)e);
            }
            out.endArray();
            out.name("predicateType");
            out.value(instance.getPredicateType());
            out.name("predicate");
            this.predicateTypeAdapter.write(out, (Object)instance.getPredicate());
            out.endObject();
        }

        private InTotoPayload readInTotoPayload(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableInTotoPayload.Builder builder = ImmutableInTotoPayload.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableInTotoPayload.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case '_': {
                    if (!"_type".equals(attributeName)) break;
                    this.readInType(in, builder);
                    return;
                }
                case 's': {
                    if (!"subject".equals(attributeName)) break;
                    this.readInSubject(in, builder);
                    return;
                }
                case 'p': {
                    if ("predicateType".equals(attributeName)) {
                        this.readInPredicateType(in, builder);
                        return;
                    }
                    if (!"predicate".equals(attributeName)) break;
                    this.readInPredicate(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInType(JsonReader in, ImmutableInTotoPayload.Builder builder) throws IOException {
            builder.type(in.nextString());
        }

        private void readInSubject(JsonReader in, ImmutableInTotoPayload.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    InTotoPayload.Subject value = (InTotoPayload.Subject)this.subjectTypeAdapter.read(in);
                    builder.addSubject(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                InTotoPayload.Subject value = (InTotoPayload.Subject)this.subjectTypeAdapter.read(in);
                builder.addSubject(value);
            }
        }

        private void readInPredicateType(JsonReader in, ImmutableInTotoPayload.Builder builder) throws IOException {
            builder.predicateType(in.nextString());
        }

        private void readInPredicate(JsonReader in, ImmutableInTotoPayload.Builder builder) throws IOException {
            JsonElement value = (JsonElement)this.predicateTypeAdapter.read(in);
            builder.predicate(value);
        }
    }
}

