/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.dsse;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonElement;
import dev.sigstore.dsse.InTotoPayload;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="InTotoPayload", generator="Immutables")
@Immutable
public final class ImmutableInTotoPayload
implements InTotoPayload {
    private final String type;
    private final ImmutableList<InTotoPayload.Subject> subject;
    private final String predicateType;
    private final JsonElement predicate;

    private ImmutableInTotoPayload(String type, ImmutableList<InTotoPayload.Subject> subject, String predicateType, JsonElement predicate) {
        this.type = type;
        this.subject = subject;
        this.predicateType = predicateType;
        this.predicate = predicate;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public ImmutableList<InTotoPayload.Subject> getSubject() {
        return this.subject;
    }

    @Override
    public String getPredicateType() {
        return this.predicateType;
    }

    @Override
    public JsonElement getPredicate() {
        return this.predicate;
    }

    public final ImmutableInTotoPayload withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableInTotoPayload(newValue, this.subject, this.predicateType, this.predicate);
    }

    public final ImmutableInTotoPayload withSubject(InTotoPayload.Subject ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableInTotoPayload(this.type, (ImmutableList<InTotoPayload.Subject>)newValue, this.predicateType, this.predicate);
    }

    public final ImmutableInTotoPayload withSubject(Iterable<? extends InTotoPayload.Subject> elements) {
        if (this.subject == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableInTotoPayload(this.type, (ImmutableList<InTotoPayload.Subject>)newValue, this.predicateType, this.predicate);
    }

    public final ImmutableInTotoPayload withPredicateType(String value) {
        String newValue = Objects.requireNonNull(value, "predicateType");
        if (this.predicateType.equals(newValue)) {
            return this;
        }
        return new ImmutableInTotoPayload(this.type, this.subject, newValue, this.predicate);
    }

    public final ImmutableInTotoPayload withPredicate(JsonElement value) {
        if (this.predicate == value) {
            return this;
        }
        JsonElement newValue = Objects.requireNonNull(value, "predicate");
        return new ImmutableInTotoPayload(this.type, this.subject, this.predicateType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInTotoPayload && this.equalTo(0, (ImmutableInTotoPayload)another);
    }

    private boolean equalTo(int synthetic, ImmutableInTotoPayload another) {
        return this.type.equals(another.type) && this.subject.equals(another.subject) && this.predicateType.equals(another.predicateType) && this.predicate.equals(another.predicate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.subject.hashCode();
        h += (h << 5) + this.predicateType.hashCode();
        h += (h << 5) + this.predicate.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"InTotoPayload").omitNullValues().add("type", (Object)this.type).add("subject", this.subject).add("predicateType", (Object)this.predicateType).add("predicate", (Object)this.predicate).toString();
    }

    public static ImmutableInTotoPayload copyOf(InTotoPayload instance) {
        if (instance instanceof ImmutableInTotoPayload) {
            return (ImmutableInTotoPayload)instance;
        }
        return ImmutableInTotoPayload.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InTotoPayload", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_PREDICATE_TYPE = 2L;
        private static final long INIT_BIT_PREDICATE = 4L;
        private long initBits = 7L;
        @Nullable
        private String type;
        private ImmutableList.Builder<InTotoPayload.Subject> subject = ImmutableList.builder();
        @Nullable
        private String predicateType;
        @Nullable
        private JsonElement predicate;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(InTotoPayload instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.getType());
            this.addAllSubject(instance.getSubject());
            this.predicateType(instance.getPredicateType());
            this.predicate(instance.getPredicate());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSubject(InTotoPayload.Subject element) {
            this.subject.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSubject(InTotoPayload.Subject ... elements) {
            this.subject.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder subject(Iterable<? extends InTotoPayload.Subject> elements) {
            this.subject = ImmutableList.builder();
            return this.addAllSubject(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSubject(Iterable<? extends InTotoPayload.Subject> elements) {
            this.subject.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder predicateType(String predicateType) {
            this.predicateType = Objects.requireNonNull(predicateType, "predicateType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder predicate(JsonElement predicate) {
            this.predicate = Objects.requireNonNull(predicate, "predicate");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableInTotoPayload build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInTotoPayload(this.type, (ImmutableList<InTotoPayload.Subject>)this.subject.build(), this.predicateType, this.predicate);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("predicateType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("predicate");
            }
            return "Cannot build InTotoPayload, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

