/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.dsse;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.dsse.InTotoPayload;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="InTotoPayload.Subject", generator="Immutables")
@Immutable
public final class ImmutableSubject
implements InTotoPayload.Subject {
    private final String name;
    private final ImmutableMap<String, String> digest;

    private ImmutableSubject(String name, ImmutableMap<String, String> digest) {
        this.name = name;
        this.digest = digest;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ImmutableMap<String, String> getDigest() {
        return this.digest;
    }

    public final ImmutableSubject withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableSubject(newValue, this.digest);
    }

    public final ImmutableSubject withDigest(Map<String, ? extends String> entries) {
        if (this.digest == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableSubject(this.name, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSubject && this.equalTo(0, (ImmutableSubject)another);
    }

    private boolean equalTo(int synthetic, ImmutableSubject another) {
        return this.name.equals(another.name) && this.digest.equals(another.digest);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.digest.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Subject").omitNullValues().add("name", (Object)this.name).add("digest", this.digest).toString();
    }

    public static ImmutableSubject copyOf(InTotoPayload.Subject instance) {
        if (instance instanceof ImmutableSubject) {
            return (ImmutableSubject)instance;
        }
        return ImmutableSubject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InTotoPayload.Subject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        private ImmutableMap.Builder<String, String> digest = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(InTotoPayload.Subject instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.putAllDigest(instance.getDigest());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putDigest(String key, String value) {
            this.digest.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putDigest(Map.Entry<String, ? extends String> entry) {
            this.digest.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder digest(Map<String, ? extends String> entries) {
            this.digest = ImmutableMap.builder();
            return this.putAllDigest(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllDigest(Map<String, ? extends String> entries) {
            this.digest.putAll(entries);
            return this;
        }

        public ImmutableSubject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSubject(this.name, (ImmutableMap<String, String>)this.digest.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Subject, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

