/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.encryption;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Keys {
    public static PublicKey parseEcdsa(byte[] contents) throws InvalidKeySpecException {
        return Keys.parse(contents, "ECDSA");
    }

    public static PublicKey parseEd25519(byte[] contents) throws InvalidKeySpecException {
        return Keys.parse(contents, "Ed25519");
    }

    public static PublicKey parseRsa(byte[] contents) throws InvalidKeySpecException {
        return Keys.parse(contents, "RSA");
    }

    public static PublicKey parseRsaPkcs1(byte[] contents) throws InvalidKeySpecException {
        try {
            ASN1Sequence sequence = ASN1Sequence.getInstance((Object)contents);
            ASN1Integer modulus = ASN1Integer.getInstance((Object)sequence.getObjectAt(0));
            ASN1Integer exponent = ASN1Integer.getInstance((Object)sequence.getObjectAt(1));
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus.getPositiveValue(), exponent.getPositiveValue());
            KeyFactory factory = KeyFactory.getInstance("RSA", "BC");
            return factory.generatePublic(keySpec);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new InvalidKeySpecException("Failed to parse pkcs1 rsa key", e);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    private static PublicKey parse(byte[] contents, String type) throws InvalidKeySpecException {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(contents);
            KeyFactory factory = KeyFactory.getInstance(type, "BC");
            return factory.generatePublic(keySpec);
        }
        catch (ArrayIndexOutOfBoundsException aoe) {
            throw new InvalidKeySpecException(aoe);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

