/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.encryption.signers;

import dev.sigstore.AlgorithmRegistry;
import dev.sigstore.encryption.signers.Signer;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class EcdsaSigner
implements Signer {
    private final KeyPair keyPair;
    private final AlgorithmRegistry.HashAlgorithm hashAlgorithm;

    EcdsaSigner(KeyPair keyPair, AlgorithmRegistry.HashAlgorithm hashAlgorithm) {
        this.keyPair = keyPair;
        this.hashAlgorithm = hashAlgorithm;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.keyPair.getPublic();
    }

    @Override
    public byte[] sign(byte[] artifact) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(String.valueOf((Object)this.hashAlgorithm) + "withECDSA");
        signature.initSign(this.keyPair.getPrivate());
        signature.update(artifact);
        return signature.sign();
    }

    @Override
    public byte[] signDigest(byte[] artifactDigest) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (artifactDigest.length != this.hashAlgorithm.getLength()) {
            throw new SignatureException("Artifact digest must be " + this.hashAlgorithm.getLength() + " bytes");
        }
        Signature signature = Signature.getInstance("NONEwithECDSA");
        signature.initSign(this.keyPair.getPrivate());
        signature.update(artifactDigest);
        return signature.sign();
    }
}

