/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.encryption.signers;

import dev.sigstore.encryption.signers.Verifier;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

class Ed25519Verifier
implements Verifier {
    private final PublicKey publicKey;

    Ed25519Verifier(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public boolean verify(byte[] artifact, byte[] signature) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature verifier = Signature.getInstance("Ed25519");
        verifier.initVerify(this.publicKey);
        verifier.update(artifact);
        return verifier.verify(signature);
    }

    @Override
    public boolean verifyDigest(byte[] digest, byte[] signature) {
        throw new UnsupportedOperationException("Ed25519 verification requires an artifact, not a digest.");
    }
}

