/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.encryption.signers;

import dev.sigstore.AlgorithmRegistry;
import dev.sigstore.encryption.signers.Signer;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.util.encoders.Hex;

public class RsaSigner
implements Signer {
    static final byte[] PKCS1_SHA256_PADDING = Hex.decode((String)"3031300d060960864801650304020105000420");
    private final KeyPair keyPair;
    private final AlgorithmRegistry.HashAlgorithm hashAlgorithm;

    RsaSigner(KeyPair keyPair, AlgorithmRegistry.HashAlgorithm hashAlgorithm) {
        this.keyPair = keyPair;
        this.hashAlgorithm = hashAlgorithm;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.keyPair.getPublic();
    }

    @Override
    public byte[] sign(byte[] artifact) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(String.valueOf((Object)this.hashAlgorithm) + "withRSA");
        signature.initSign(this.keyPair.getPrivate());
        signature.update(artifact);
        return signature.sign();
    }

    @Override
    public byte[] signDigest(byte[] artifactDigest) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (artifactDigest.length != this.hashAlgorithm.getLength()) {
            throw new SignatureException("Artifact digest must be " + this.hashAlgorithm.getLength() + " bytes");
        }
        Signature signature = Signature.getInstance("NONEwithRSA");
        signature.initSign(this.keyPair.getPrivate());
        signature.update(PKCS1_SHA256_PADDING);
        signature.update(artifactDigest);
        return signature.sign();
    }
}

